<?php

class PeepsoMigrateBBAdminMigrate {

	var $limit = 0;
	var $next_limit = 0;
	var $per_page = 50;
	var $peepso_dir;
	var $counter = 0;

	var $photos;
	var $photos_model;

	function __construct() {
		$this->peepso_dir = PeepSo::get_peepso_dir();

		if (isset($_REQUEST["limit"])) {
			$this->limit = sanitize_text_field($_REQUEST["limit"]);
		}

		$this->next_limit = $this->limit + $this->per_page;

		if (!function_exists('get_home_path')) {
			require_once( ABSPATH . 'wp-admin/includes/file.php' );
		}

		if (class_exists('PeepSoSharePhotos')) {
			$this->photos = PeepSoSharePhotos::get_instance();
			$this->photos_model = new PeepSoPhotosModel();
		}
	}

	function startMigrateProfiles() {
		global $wpdb;

		// move gender field
		$gender_field = get_transient('peepso_migrate_gender_field');
		$gender_field_male = get_transient('peepso_migrate_gender_field_male');
		$gender_field_female = get_transient('peepso_migrate_gender_field_female');

		if (!empty($gender_field) && !empty($gender_field_male) && !empty($gender_field_female)) {

			$sql = $wpdb->prepare("SELECT A.user_id, C.id AS option_id FROM " . $wpdb->prefix . "bp_xprofile_data A " .
					"LEFT JOIN " . $wpdb->prefix . "users B ON B.ID = A.user_id " .
					"LEFT JOIN " . $wpdb->prefix . "bp_xprofile_fields C ON C.parent_id = A.field_id AND replace(replace(replace(A.value, 'his_', ''), 'her_', ''), 'their_', '') = C.name " .
					"WHERE C.type NOT IN('wp-biography', 'wp-textbox', 'socialnetworks') AND field_id = %d LIMIT %d, %d", $gender_field, $this->limit, $this->per_page);
			$all_gender_field = $wpdb->get_results($sql);

			if (isset($all_gender_field) && 0 < count($all_gender_field)) {

				$sql = $wpdb->prepare("SELECT A.* FROM " . $wpdb->prefix . "bp_xprofile_fields A " .
						"WHERE parent_id = %d AND type = %s AND id NOT IN ( %d, %d) ORDER BY id ASC", $gender_field, 'option', $gender_field_male, $gender_field_female);
				$all_custom_gender = $wpdb->get_results($sql);

				foreach ($all_gender_field as $key => $value) {

					if ($value->option_id == $gender_field_female) {
						$gender = 'f';
					} else if ($value->option_id == $gender_field_male) {
						$gender = 'm';
					} else {
						for ($i = 1; $i <= count($all_custom_gender); $i++) {
							$gender_field_custom = get_transient('peepso_migrate_gender_field_custom' . ($i + 2));

							if (!empty($gender_field_custom) && ($gender_field_custom == $value->option_id)) {
								$gender = 'c' . ($gender_field_custom);
							}
						}
					}

					$sql = $wpdb->prepare("INSERT INTO " . $wpdb->prefix . "usermeta (`user_id`, `meta_key`, `meta_value`) values (%d, %s, %s)", $value->user_id, 'peepso_user_field_gender', $gender);
					$wpdb->query($sql);
				}
			}
		}

		// move birthdate field
		$birthdate_field = get_transient('peepso_migrate_birthdate_field');
		if (!empty($birthdate_field)) {
			$sql = $wpdb->prepare("SELECT A.* FROM " . $wpdb->prefix . "bp_xprofile_data A " .
					"LEFT JOIN " . $wpdb->prefix . "users B ON B.ID = A.user_id " .
					"WHERE field_id = %d LIMIT %d, %d", $birthdate_field, $this->limit, $this->per_page);
			$all_birthdate_field = $wpdb->get_results($sql);

			if (isset($all_birthdate_field) && 0 < count($all_birthdate_field)) {
				foreach ($all_birthdate_field as $key => $value) {
					$birthdate = str_replace(' 00:00:00', '', $value->value);
					$sql = $wpdb->prepare("INSERT INTO " . $wpdb->prefix . "usermeta (`user_id`, `meta_key`, `meta_value`) values (%d, %s, %s)", $value->user_id, 'peepso_user_field_birthdate', $birthdate);
					$wpdb->query($sql);
				}
			}
		}

		$sql = $wpdb->prepare("SELECT u.*, m.`meta_value` as last_activity FROM " . $wpdb->prefix . "users u left outer join " . $wpdb->prefix . "usermeta m on u.`ID`=m.`user_id` and m.`meta_key`='last_activity' limit %d, %d", $this->limit, $this->per_page);
		$all_users = $wpdb->get_results($sql);

		if (isset($all_users) && 0 < count($all_users)) {
			foreach ($all_users as $key => $user) {
				$sql = $wpdb->prepare("select count(*) as total from " . $wpdb->prefix . "peepso_users where `usr_id`=%d", intval($user->ID));
				$total = $wpdb->get_results($sql);
				$total = $total["0"]->total;

				if (0 == intval($total)) {

					$sql = $wpdb->prepare("insert into " . $wpdb->prefix . "peepso_users (`usr_id`, `usr_last_activity`, `usr_views`, `usr_likes`, `usr_role`, `usr_send_emails`, `usr_cover_photo`, `usr_avatar_custom`, `usr_profile_acc`, `usr_first_name_acc`, `usr_last_name_acc`, `usr_description_acc`, `usr_user_url_acc`, `usr_gender`, `usr_gender_acc`, `usr_birthdate`, `usr_birthdate_acc`) values ('%d', '%s', '0', '0', 'member', '1', '', '0', '10', '10', '10', '10', '10', 'u', '10', '', '10')", intval($user->ID), trim($user->last_activity));
					$wpdb->query($sql);

					// set visibility for gender and birthdate
					$gender_acc = PeepSo::ACCESS_PUBLIC;
					if (!empty($gender_field) && !empty($gender_field_male) && !empty($gender_field_female)) {
						$gender_acc = $this->_get_field_visibility(intval($user->ID), $gender_field);
						update_user_meta(intval($user->ID), 'peepso_user_field_gender_acc', $gender_acc);
					}

					$birthdate_acc = PeepSo::ACCESS_PUBLIC;
					if (!empty($birthdate_field)) {
						$birthdate_acc = $this->_get_field_visibility(intval($user->ID), $birthdate_field);
						update_user_meta(intval($user->ID), 'peepso_user_field_birthdate_acc', $birthdate_acc);
					}
				}
			}
			$next_url = PeepsoMigrateBB::url('profile&limit=' . $this->next_limit);
		} else {
			$next_url = PeepsoMigrateBB::url('avatar');
		}

		return array(
			'url' => $next_url,
			'class' => 'profile',
			'counter' => count($all_users),
		);
	}

	function startMigrateAvatars() {
		global $wpdb;

		$sql = $wpdb->prepare("SELECT * FROM " . $wpdb->prefix . "users limit %d, %d", $this->limit, $this->per_page);
		$all_users = $wpdb->get_results($sql);

		@mkdir($this->peepso_dir);
		$target_dir = $this->peepso_dir . 'users';
		@mkdir($target_dir);

		$upload_dir = wp_upload_dir();
		$upload_path = $upload_dir['basedir'] . DIRECTORY_SEPARATOR;

		if (isset($all_users) && 0 < count($all_users)) {
			$path = get_home_path();

			foreach ($all_users as $key => $user) {
				wp_set_current_user($user->ID);

				if ($this->photos) {
					$this->photos->create_album(PeepSoUser::get_instance($user->ID));
				}
				
				@mkdir($target_dir . DIRECTORY_SEPARATOR . $user->ID);

				if (is_dir($upload_path . "avatars" . DIRECTORY_SEPARATOR . $user->ID)) {
					$buddy_avatars = scandir($upload_path . "avatars" . DIRECTORY_SEPARATOR . $user->ID);
					if (isset($buddy_avatars) && 0 < count($buddy_avatars)) {
						foreach ($buddy_avatars as $poz => $file) {
							if ("." != $file && ".." != $file && "" != $file) {
								if (FALSE !== strpos($file, "bpfull")) {
									$file_array = explode(".", $file);
									$extension = $file_array[count($file_array) - 1];

									$source = $upload_path . "avatars" . DIRECTORY_SEPARATOR . $user->ID . DIRECTORY_SEPARATOR . $file;
									$destination1 = $target_dir . DIRECTORY_SEPARATOR . $user->ID . DIRECTORY_SEPARATOR . 'avatar-full.jpg';
									$destination2 = $target_dir . DIRECTORY_SEPARATOR . $user->ID . DIRECTORY_SEPARATOR . 'avatar-orig.jpg';

									if ($extension == 'png') {
										$this->_png2jpg($source, $destination1);
										$this->_png2jpg($source, $destination2);
									} else if ($extension == 'webp') {
										$this->_webp2jpg($source, $destination1);
										$this->_webp2jpg($source, $destination2);
									} else {
										copy($source, $destination1);
										copy($source, $destination2);
									}

									$sql = $wpdb->prepare("update " . $wpdb->prefix . "peepso_users set `usr_avatar_custom`='1' where `usr_id`='%d'", intval($user->ID));
									$wpdb->query($sql);

									if ($this->photos) {
										$this->save_avatar_and_cover($user, 'avatar', $destination2);
									}
								} else if (FALSE !== strpos($file, "bpthumb")) {
									$file_array = explode(".", $file);
									$extension = $file_array[count($file_array) - 1];

									$source = $upload_path . "avatars" . DIRECTORY_SEPARATOR . $user->ID . DIRECTORY_SEPARATOR . $file;
									$destination = $target_dir . DIRECTORY_SEPARATOR . $user->ID . DIRECTORY_SEPARATOR . 'avatar.jpg';

									if ($extension == 'png') {
										$this->_png2jpg($source, $destination);
									} else if ($extension == 'webp') {
										$this->_webp2jpg($source, $destination);
									} else {
										copy($source, $destination);
									}

									$sql = $wpdb->prepare("update " . $wpdb->prefix . "peepso_users set `usr_avatar_custom`='1' where `usr_id`='%d'", intval($user->ID));
									$wpdb->query($sql);
								}
							}
						}
					}
				}

				if (is_dir($upload_path . "buddypress" . DIRECTORY_SEPARATOR . "members" . DIRECTORY_SEPARATOR . $user->ID . DIRECTORY_SEPARATOR . "cover-image")) {
					$buddy_cover = scandir($upload_path . "buddypress" . DIRECTORY_SEPARATOR . "members" . DIRECTORY_SEPARATOR . $user->ID . DIRECTORY_SEPARATOR . "cover-image");

					if (isset($buddy_cover) && 0 < count($buddy_cover)) {
						foreach ($buddy_cover as $poz => $file) {
							if ("." != $file && ".." != $file && "" != $file) {
								if (FALSE !== strpos($file, "bp-cover-image")) {
									$file_array = explode(".", $file);
									$extension = $file_array[count($file_array) - 1];

									$source = $upload_path . "buddypress" . DIRECTORY_SEPARATOR . "members" . DIRECTORY_SEPARATOR . $user->ID . DIRECTORY_SEPARATOR . "cover-image" . DIRECTORY_SEPARATOR . $file;
									$destination = $target_dir . DIRECTORY_SEPARATOR . $user->ID . DIRECTORY_SEPARATOR . 'cover.jpg';

									if ($extension == 'png') {
										$this->_png2jpg($source, $destination);
									} else if ($extension == 'webp') {
										$this->_webp2jpg($source, $destination);
									} else {
										copy($source, $destination);
									}

									$site_url = get_site_url();
									$image_path = PeepSo::get_peepso_uri() . "users/" . $user->ID . "/cover.jpg";

									$sql = $wpdb->prepare("update " . $wpdb->prefix . "peepso_users set `usr_cover_photo`='%s' where `usr_id`='%d'", trim($image_path), intval($user->ID));
									$wpdb->query($sql);

									if ($this->photos) {
										$this->save_avatar_and_cover($user, 'cover', $destination);
									}
								}
							}
						}
					}
				}
			}
			$next_url = PeepsoMigrateBB::url('avatar&limit=' . $this->next_limit);
		} else {
			$next_url = PeepsoMigrateBB::url('friend');
		}

		return array(
			'url' => $next_url,
			'class' => 'avatar',
			'counter' => count($all_users),
		);
	}

	private function save_avatar_and_cover($user, $type, $file) {
		global $wpdb;

		$post_id = wp_insert_post([
			'post_type' => 'peepso-post',
			'post_status' => 'pending',
			'post_author' => $user->ID,
			'post_title' => $type
		]);

		if ($type == 'avatar') {
			$meta = $this->photos::POST_META_KEY_PHOTO_TYPE_AVATAR;
			$album = $this->photos::ALBUM_AVATARS;
		} else {
			$meta = $this->photos::POST_META_KEY_PHOTO_TYPE_COVER;
			$album = $this->photos::ALBUM_COVERS;
		}
		$meta = 'POST_META_KEY_PHOTO_TYPE_' . strtoupper($type);

		add_post_meta($post_id, $this->photos::POST_META_KEY_PHOTO_TYPE, $meta, true);

		$wpdb->insert($wpdb->prefix . 'peepso_activities', [
			'act_owner_id' => $user->ID,
			'act_external_id' => $post_id,
			'act_module_id' => 4,
			'act_access' => 10
		]);

		$act_id = $wpdb->insert_id;

		$this->photos_model->get_photo_dir($user->ID, TRUE);
		$this->photos_model->save_images_profile($file, $post_id, $act_id, $album);
	}

	private function save_avatar_and_cover_group($user_id, $group_id, $type, $file) {
		global $wpdb;

		$post_id = wp_insert_post([
			'post_type' => 'peepso-post',
			'post_status' => 'pending',
			'post_author' => $user_id,
			'post_title' => $type
		]);

		if ($type == 'avatar') {
			$meta = $this->photos::POST_META_KEY_PHOTO_TYPE_AVATAR;
			$album = PeepSoGroupsPlugin::MODULE_ID . $this->photos::ALBUM_AVATARS;
		} else {
			$meta = $this->photos::POST_META_KEY_PHOTO_TYPE_COVER;
			$album = PeepSoGroupsPlugin::MODULE_ID . $this->photos::ALBUM_COVERS;
		}

		add_post_meta($post_id, $this->photos::POST_META_KEY_PHOTO_TYPE, $meta, true);
		add_post_meta($post_id, 'peepso_group_id', $group_id);

		$wpdb->insert($wpdb->prefix . 'peepso_activities', [
			'act_owner_id' => $user_id,
			'act_external_id' => $post_id,
			'act_module_id' => 4,
			'act_access' => 10
		]);

		$act_id = $wpdb->insert_id;

		$this->photos_model->get_photo_dir($user_id, TRUE);
		$this->photos_model->save_images_profile($file, $post_id, $act_id, $album);
	}

	function startMigrateFriends() {
		$next_url = PeepsoMigrateBB::url('album');

		if (PeepsoMigrateBB::plugin_check('friend')) {
			global $wpdb;

			$sql = $wpdb->prepare("SELECT * FROM " . $wpdb->prefix . "bp_friends limit %d, %d", $this->limit, $this->per_page);
			$all_friends = $wpdb->get_results($sql);

			if (isset($all_friends) && 0 < count($all_friends)) {
				foreach ($all_friends as $key => $value) {
					$fnd_user_id = $value->initiator_user_id;
					$fnd_friend_id = $value->friend_user_id;
					$fnd_created = $value->date_created;
					$freq_viewed = $value->is_confirmed;

					if (0 == $freq_viewed) {
						$wpdb->insert($wpdb->prefix . 'peepso_friend_requests', [
							'freq_user_id'   => intval($fnd_user_id),
							'freq_friend_id' => intval($fnd_friend_id),
							'freq_created'   => $fnd_created,
							'freq_viewed'    => intval($freq_viewed)
						]);
					} else {
						$wpdb->insert($wpdb->prefix . 'peepso_friends', [
							'fnd_user_id'   => intval($fnd_user_id),
							'fnd_friend_id' => intval($fnd_friend_id),
							'fnd_created'   => $fnd_created
						]);

						new PeepSoUserFollower($fnd_user_id, $fnd_friend_id, TRUE);
						new PeepSoUserFollower($fnd_friend_id, $fnd_user_id, TRUE);
					}
				}
				$next_url = PeepsoMigrateBB::url('friend&limit=' . $this->next_limit);
			}

			$this->counter = count($all_friends);
		}

		return array(
			'url' => $next_url,
			'class' => 'friend',
			'counter' => $this->counter,
		);
	}

	public function startMigrateAlbum() {
		$next_url = PeepsoMigrateBB::url('activity');

		if (class_exists('PeepSoSharePhotos')) {
			global $wpdb;

			$sql = $wpdb->prepare("SELECT * FROM " . $wpdb->prefix . "bp_media_albums where `group_id` = 0 limit %d, %d", $this->limit, $this->per_page);
			$all_album = $wpdb->get_results($sql);

			if (isset($all_album) && 0 < count($all_album)) {
				add_action('peepso_activity_after_add_post', 	array(PeepSoSharePhotos::get_instance(), 'after_add_post'), 10, 2);
				add_action('peepso_activity_after_add_post', array(PeepSoSharePhotos::get_instance(), 'after_add_post_album'), 10, 2);
				add_filter('peepso_activity_allow_empty_content', array(PeepSoSharePhotos::get_instance(), 'activity_allow_empty_content'), 10, 1);

				foreach ($all_album as $key => $album) {
					// check if previous activity already migrated
					$check = $this->get_memory('album', $album->id);
					if (!empty($check)) {
						continue;
					}

					$privacy = PeepSo::ACCESS_PUBLIC;
					if ($album->privacy == 'onlyme') {
						$privacy = 40;
					} else if ($album->privacy == 'friends' && PeepsoMigrateBB::plugin_check('friend')) {
						$privacy = 30;
					} else if ($album->privacy == 'loggedin') {
						$privacy = 20;
					} else {
						$privacy = 10;
					}

					$_GET = array();
					$_GET['user_id'] = $album->user_id;
					$_GET['name'] = $album->title;
					$_GET['privacy'] = $privacy;
					$_GET['description'] = '';
					$_GET['type'] = 'album';

					wp_set_current_user($album->user_id);
					$owner = $album->user_id;
					$name = $album->title;
					$description = $album->title;

					$sql = $wpdb->prepare("SELECT * FROM " . $wpdb->prefix . "bp_media where `group_id` = 0 and album_id = %d", $album->id);
					$all_files = $wpdb->get_results($sql);
					$files = array();				
					foreach ($all_files as $key => $media) {
						$attachment = get_attached_file($media->attachment_id);
						$filename = basename($attachment);

						$dir = $this->photos_model->get_photo_dir($album->user_id, true);
						@mkdir($dir, 0755, TRUE);
						@mkdir($dir.'tmp', 0755, TRUE);

						$tmp_file = $this->photos_model->get_tmp_file($filename);
						$filetype = wp_check_filetype($tmp_file['path']);
						$filetype['ext'] = str_replace('jpeg', 'jpg', $filetype['ext']);
						$filehash = md5($tmp_file['name'] . time());
						$filename =  $filehash . '.' . $filetype['ext'];

						$tmp_file['path'] = str_replace($tmp_file['name'], $filename, $tmp_file['path']);
						$tmp_file['name'] = $filename;
						
						@copy($attachment, $tmp_file['path']);
						array_push($files, $tmp_file['name']);
					}
					$_GET['photo'] = $files;

					if (count($files) > 0) {
						// create post
						$content = $description;
						$extra = array(
							'module_id' => PeepSoSharePhotos::MODULE_ID,
							'act_access' => $privacy,
							'post_date' => $album->date_created,
							'post_date_gmt' => $album->date_created,
						);

						// create post
						$peepso_activity = PeepSoActivity::get_instance();
						$post_id = $peepso_activity->add_post($owner, $owner, $content, $extra);
						add_post_meta($post_id, PeepSoSharePhotos::POST_META_KEY_PHOTO_TYPE, PeepSoSharePhotos::POST_META_KEY_PHOTO_TYPE_ALBUM, true);
						add_post_meta($post_id, PeepSoSharePhotos::POST_META_KEY_PHOTO_COUNT, count($files), true);

						$this->add_memory('album', $album->id, $post_id);
						$album_activity = $wpdb->get_row($wpdb->prepare("SELECT activity_id FROM " . $wpdb->prefix . "bp_activity_meta WHERE meta_key = 'bp_media_album_activity' AND meta_value = %d", $album->id));
						if ($album_activity) {
							$this->add_memory('activity', $album_activity->activity_id, $post_id);
							$this->add_memory('activity_module', $album_activity->activity_id, PeepSoSharePhotos::MODULE_ID);
							$this->add_memory('activity_owner', $album_activity->activity_id, $owner);
						}

						// search for activity meta
						$sql = $wpdb->prepare("SELECT meta_value FROM " . $wpdb->prefix . "bp_activity_meta WHERE meta_key = 'bp_favorite_users' AND activity_id = %d", $album_activity->activity_id);
						$likes = $wpdb->get_row($sql);
						if ($likes) {
							$users_like = unserialize($likes->meta_value);

							foreach ($users_like as $user_id) {
								$wpdb->insert($wpdb->prefix . 'peepso_likes', [
									'like_user_id'     => $user_id,
									'like_external_id' => $post_id,
									'like_module_id'   => PeepSoSharePhotos::MODULE_ID,
									'like_type'        => 1,
									'like_timestamp'   => current_time('timestamp')
								]);
							}
						}
					}
				}

				$next_url = PeepsoMigrateBB::url('album&limit=' . $this->next_limit);
			}

			$this->counter = count($all_album);
		}

		return array(
			'url' => $next_url,
			'class' => 'album',
			'counter' => $this->counter,
		);
	}

	public function startMigrateActivity() {
		$next_url = PeepsoMigrateBB::url('notification');

		if (PeepsoMigrateBB::plugin_check('activity')) {
			global $wpdb;

			$sql = $wpdb->prepare("SELECT * FROM " . $wpdb->prefix . "bp_activity WHERE `component` NOT IN ('members', 'groups', 'friends', 'profile') limit %d, %d", $this->limit, $this->per_page);
			$all_activities = $wpdb->get_results($sql);

			if (isset($all_activities) && 0 < count($all_activities)) {
				if ($this->photos) {
					add_action('peepso_activity_after_add_post', array(PeepSoSharePhotos::get_instance(), 'after_add_post'), 20, 2);
					add_action('peepso_activity_after_save_comment', array(PeepSoSharePhotos::get_instance(), 'after_save_comment'), 20, 2);
				}
				if (class_exists('PeepSoVideos')) {
					add_action('peepso_activity_after_add_post', array(PeepSoVideos::get_instance(), 'after_add_post'), 20, 2);
					$videos_model = new PeepSoVideosModel();
				}

				foreach ($all_activities as $key => $post) {
					if ('members' == $post->component || 'groups' == $post->component) {
						continue;
					}

					// Skip if it's photos update
					if ($post->privacy == 'media') {
						continue;
					}

					// Skip if it's album update
					$album_activity = $wpdb->get_row($wpdb->prepare("SELECT activity_id FROM " . $wpdb->prefix . "bp_activity_meta WHERE meta_key = 'bp_media_album_activity' AND activity_id = %d", $post->id));
					if ($album_activity && $post->type != 'activity_comment') {
						continue;
					}

					// check if parent activity is group
					$is_group_activity = FALSE;

					$sql = "SELECT A.id, A.component, @pv:=A.secondary_item_id AS parent FROM (select * from " . $wpdb->prefix . "bp_activity ORDER BY id DESC) A JOIN (SELECT @pv:=$post->secondary_item_id) tmp WHERE A.id=@pv";
					$parents = $wpdb->get_results($sql);

					if (count($parents) > 0) {
						foreach ($parents as $p) {
							if ($p->component == 'groups') {
								$is_group_activity = TRUE;
							}
						}
					}

					if ($is_group_activity) {
						continue;
					}

					$post_type = 'peepso-post';

					if ($post->type == 'activity_comment') {
						$post_type = 'peepso-comment';
					}

					$post_content = strip_tags($post->content);

					if (empty($post_content) && $post->component != 'activity') {
						continue;
					}

					if ($post->component == 'blogs' && $post->type == 'new_blog_post') {
						$post_content = '{"post_id":' . $post->secondary_item_id . ',"post_type":"post","shortcode":"peepso_postnotify"}';
					}

					// convert tags
					if (class_exists('PeepSoTags')) {
						preg_match_all("/\@(\w+)/", $post_content, $matches);
						if (count($matches[1]) > 0) {
							foreach ($matches[1] as $username) {
								$user = get_user_by('slug', $username);

								if ($user) {
									$post_content = str_replace('@' . $username, '[peepso_tag id=' . $user->ID . ']' . $username . '[/peepso_tag]', $post_content);
								}
							}
						}
					}

					$timestamp = strtotime($post->date_recorded);

					$aPostData = array(
						'post_author' => $post->user_id,
						'post_date' => $post->date_recorded,
						'post_date_gmt' => $post->date_recorded,
						'post_content' => $post_content,
						'post_title' => $post->user_id . "-" . $post->user_id . "-" . $timestamp,
						'post_excerpt' => $post_content,
						'post_status' => 'publish',
						'comment_status' => 'open',
						'ping_status' => 'open',
						'post_password' => '',
						'post_name' => $post->user_id . "-" . $post->user_id . "-" . $timestamp,
						'to_ping' => '',
						'pinged' => '',
						'post_modified' => $post->date_recorded,
						'post_modified_gmt' => $post->date_recorded,
						'post_content_filtered' => '',
						'post_parent' => 0,
						'guid' => get_site_url() . '/' . $post_type . '/' . $post->user_id . "-" . $post->user_id . "-" . $timestamp . '/',
						'menu_order' => 0,
						'post_type' => $post_type,
						'post_mime_type' => '',
						'comment_count' => 0
					);

					$peepso_new_post_id = wp_insert_post($aPostData);

					$this->add_memory('activity', $post->id, $peepso_new_post_id);

					$module_id = 1;
					if ($post->type == 'activity_comment') {
						$bp_peepso_parent_id = $this->get_memory('activity', $post->item_id);

						// if empty, it's group post
						if (empty($bp_peepso_parent_id)) {
							continue;
						}

						$bp_peepso_parent_module_id = $this->get_memory('activity_module', $post->item_id);
						if (!empty($bp_peepso_parent_module_id)) {
							$module_id = $bp_peepso_parent_module_id;
						}

						$comment_author = $post->user_id;
						$bp_peepso_parent_owner = $this->get_memory('activity_owner', $post->item_id);
						if (!empty($bp_peepso_parent_owner)) {
							$comment_author = $bp_peepso_parent_owner;
						}

						// if regular comment
						if ($post->item_id != $post->secondary_item_id) {
							if (count($parents) > 0) {
								foreach ($parents as $p) {
									if ($p->parent == $post->item_id) {
										$bp_peepso_parent_id = $this->get_memory('activity', $p->id);
									}
								}
							}
						}

						$wpdb->insert($wpdb->prefix . 'peepso_activities', [
							'act_owner_id'          => $comment_author,
							'act_external_id'       => intval($peepso_new_post_id),
							'act_has_replies'       => 1,
							'act_module_id'         => 1,
							'act_comment_object_id' => $bp_peepso_parent_id,
							'act_comment_module_id' => $module_id,
						]);

						$this->add_memory('act_id', $post->id, $wpdb->insert_id);
					} else {
						if ($post->privacy == 'onlyme') {
							$act_access = 40;
						} else if ($post->privacy == 'friends' && PeepsoMigrateBB::plugin_check('friend')) {
							$act_access = 30;
						} else if ($post->privacy == 'loggedin') {
							$act_access = 20;
						} else {
							$act_access = 10;
						}

						$wpdb->insert($wpdb->prefix . 'peepso_activities', [
							'act_owner_id'          => $post->user_id,
							'act_external_id'       => intval($peepso_new_post_id),
							'act_access'			=> $act_access,
							'act_has_replies'       => 0,
							'act_module_id'         => 1,
							'act_comment_object_id' => 0,
							'act_comment_module_id' => 0,
						]);

						$this->add_memory('act_id', $post->id, $wpdb->insert_id);
						$module_id = 1;
					}

					if ($post_type == 'peepso-post') {
						$this->save_link_preview($peepso_new_post_id, $post_content);
					}
					// search for activity meta
					$sql = $wpdb->prepare("SELECT * FROM " . $wpdb->prefix . "bp_activity_meta WHERE activity_id = %d", $post->id);
					$metas = $wpdb->get_results($sql);

					if ($metas) {
						foreach ($metas as $meta) {
							if ($meta->meta_key == 'bp_favorite_users') {
								$users_like = unserialize($meta->meta_value);

								foreach ($users_like as $user_id) {
									$wpdb->insert($wpdb->prefix . 'peepso_likes', [
										'like_user_id'     => $user_id,
										'like_external_id' => $peepso_new_post_id,
										'like_module_id'   => $module_id,
										'like_type'        => 1,
										'like_timestamp'   => current_time('timestamp')
									]);
								}

							} else if ($meta->meta_key == '_gif_data') {
								// gif

								$data = unserialize($meta->meta_value);
								$gif = '';
								if (isset($data['mp4'])) {
									$gif = str_replace('.mp4', '.gif', $data['mp4']);
								} else if (isset($data['gif'])) {
									$gif = $$data['gif'];
								}

								if ($gif) {
									add_post_meta($peepso_new_post_id, 'peepso_giphy', $gif);
								}
							} else if (($meta->meta_key == 'bp_media_ids' || $meta->meta_key == 'bp_video_ids') && ($this->photos || class_exists('PeepSoVideos'))) {
								// attachment id
								$attachment_ids = explode(',', $meta->meta_value);
								$activity = $wpdb->get_row("SELECT * FROM " . $wpdb->prefix . "peepso_activities ORDER BY act_id DESC LIMIT 1");
								$act_id = $activity->act_id;

								foreach ($attachment_ids as $attachment_id) {
									$media = $wpdb->get_row($wpdb->prepare("SELECT * FROM " . $wpdb->prefix . "bp_media WHERE id = %d", $attachment_id));

									if (!is_object($media)) continue;

									// skip if an album
									if ($media->album_id > 0 && $media->type == 'photo') {
										continue;
									}

									// skip if it's from groups
									if ($media->group_id > 0) {
										continue;
									}
									
									if ($media->type == 'photo' || $media->type == 'video') {
										$attachment = get_attached_file($media->attachment_id);

										$filename = basename($attachment);
										// get act id
										$_GET['type'] = $media->type;

										if ($media->type == 'photo' && $this->photos) {
											if ($post_type == 'peepso-post') {
												$module_id = 4;
												$wpdb->query($wpdb->prepare("UPDATE " . $wpdb->prefix . "peepso_activities SET act_module_id = %d WHERE act_id = %d", 4, $act_id));
											}

											wp_set_current_user($post->user_id);
											$user = PeepSoUser::get_instance($post->user_id);
											PeepSoSharePhotos::get_instance()->create_album($user);

											$dir = $this->photos_model->get_photo_dir($post->user_id, true);

											@mkdir($dir, 0755, TRUE);
											@mkdir($dir.'tmp', 0755, TRUE);

											$tmp_file = $this->photos_model->get_tmp_file($filename);
											$filetype = wp_check_filetype($tmp_file['path']);
											$filetype['ext'] = str_replace('jpeg', 'jpg', $filetype['ext']);
											$filehash = md5($tmp_file['name'] . time());
											$filename =  $filehash . '.' . $filetype['ext'];

											$tmp_file['path'] = str_replace($tmp_file['name'], $filename, $tmp_file['path']);
											$tmp_file['name'] = $filename;

											@copy($attachment, $tmp_file['path']);
											if ($post_type == 'peepso-post') {
												$_GET['files'] = [$tmp_file['name']];
											} else {
												$_GET['photo'] = $tmp_file['name'];
											}
										} else if ($media->type == 'video' && class_exists('PeepSoVideos')) {
											$wpdb->query($wpdb->prepare("UPDATE " . $wpdb->prefix . "peepso_activities SET act_module_id = %d WHERE act_id = %d", 5, $act_id));

											$user = PeepSoUser::get_instance(get_current_user_id());
								
											$dir = $videos_model->get_video_dir();
											if (!is_dir($dir)) {
												mkdir($dir, 0755, TRUE);
											}

											$tmp_file = $videos_model->get_tmp_file($filename);
											$filetype = wp_check_filetype($tmp_file['path'], PeepSoVideosUpload::$allowed_mime_types);
											$filehash = md5($tmp_file['name'] . time());
											$filename =  $filehash . '.' . $filetype['ext'];
								
											$tmp_file['path'] = str_replace($tmp_file['name'], $filename, $tmp_file['path']);
											$tmp_file['name'] = $filename;
								
											@copy($attachment, $tmp_file['path']);
											$_GET['type'] = 'video';
											$_GET['video_title'] = $filename;
											$_GET['video'] = $tmp_file['name'];
										}

										if ($post_type == 'peepso-post') {
											do_action('peepso_activity_after_add_post', $peepso_new_post_id, $act_id);
										} else {
											do_action('peepso_activity_after_save_comment', $peepso_new_post_id, $activity);
										}
										$_GET = NULL;

										$this->add_memory('activity_module', $post->id, PeepSoSharePhotos::MODULE_ID);
										$this->add_memory('activity_owner', $post->id, $post->user_id);
									}
								}
							}

						}
					}
				}
				$next_url = PeepsoMigrateBB::url('activity&limit=' . $this->next_limit);

				$this->counter = count($all_activities);
			}
		}


		return array(
			'url' => $next_url,
			'class' => 'activity',
			'counter' => $this->counter,
		);
	}

	private function save_link_preview($post_id, $post_content) {
		preg_match_all('#\bhttps?://[^,\s()<>]+(?:\([\w\d]+\)|([^,[:punct:]\s]|/))#', $post_content, $match);

		if ($match[0] && count($match[0])) {
			$embed = apply_filters('peepso_embed_content', array(), $match[0][0]);
            if (isset($embed['data'])) {
                // Use a new key to separate from the previous media data.
                $embed = array('embed' => $embed['data']);
				add_post_meta($post_id, 'peepso_media', $embed);
            }
		}
	}

	function startMigrateNotifications() {
		$next_url = PeepsoMigrateBB::url('message');

		if (PeepsoMigrateBB::plugin_check('notification')) {
			global $wpdb;

			$sql = $wpdb->prepare("SELECT bpn.*, bpa.user_id as not_from_user_id FROM " . $wpdb->prefix . "bp_notifications bpn, " . $wpdb->prefix . "bp_activity bpa where bpn.`item_id`=bpa.`id` AND bpn.`component_name` = %s limit %d, %d", 'activity', $this->limit, $this->per_page);
			$all_notifications = $wpdb->get_results($sql);

			if (isset($all_notifications) && 0 < count($all_notifications)) {
				foreach ($all_notifications as $key => $value) {
					$type = $msg = '';

					if ($value->component_action == 'update_reply') {
						$type = 'user_comment';
						$msg = 'commented on your post';
					} else
					if ($value->component_action == 'comment_reply') {
						$type = 'stream_reply_comment';
						$msg = 'replied to your comment';
					} else
					if ($value->component_action == 'new_at_mention') {
						$type = 'tag';
						$msg = 'mentioned you in a post';
					}

					$not_external_id = $this->get_memory('activity', $value->item_id);
					$not_act_id = $this->get_memory('act_id', $value->item_id);

					if (!empty($type) && !empty($not_external_id) && !empty($not_act_id)) {
						$data = array(
							'not_user_id' => $value->user_id,
							'not_from_user_id' => $value->not_from_user_id,
							'not_timestamp' => $value->date_notified,
							'not_module_id' => 1,
							'not_external_id' => $not_external_id,
							'not_act_id' => $not_act_id,
							'not_type' => $type,
							'not_message' => $msg,
							'not_message_args' => json_encode(array('peepso-core')),
							'not_read' => $value->is_new,
							'not_processed_canvas_push' => -1,
						);
						$wpdb->insert($wpdb->prefix . 'peepso_notifications', $data);
					}
				}
				$next_url = PeepsoMigrateBB::url('notification&limit=' . $this->next_limit);

				$this->counter = count($all_notifications);
			}
		}

		return array(
			'url' => $next_url,
			'class' => 'notification',
			'counter' => $this->counter,
		);
	}

	function startMigrateMessages() {
		$next_url = PeepsoMigrateBB::url('profile_field');

		if (PeepsoMigrateBB::plugin_check('message')) {
			if ($this->photos) {
				add_action('peepso_activity_after_add_post', array(PeepSoSharePhotos::get_instance(), 'after_add_post'), 20, 2);
			}

			register_post_type(PeepSoMessagesPlugin::CPT_MESSAGE);

			global $wpdb;
			$sql = $wpdb->prepare("SELECT * FROM " . $wpdb->prefix . "bp_messages_messages ORDER BY id ASC LIMIT %d, %d ", $this->limit, $this->per_page);
			$all_messages = $wpdb->get_results($sql);

			if (isset($all_messages) && 0 < count($all_messages)) {
				$thread_id = $prev_thread_id = 0;

				$existing_thread_id = $existing_parent_post_id = $existing_recipients = array();

				foreach ($all_messages as $key => $value) {
					$sql = $wpdb->prepare("SELECT * FROM " . $wpdb->prefix . "bp_messages_recipients where `thread_id`=%d", intval($value->thread_id));
					$all_recipients = $wpdb->get_results($sql);

					$current_recipients = $unread_count = $is_deleted = array();

					if (isset($all_recipients) && 0 < count($all_recipients)) {
						foreach ($all_recipients as $rec_key => $rec_value) {
							$current_recipients[] = intval($rec_value->user_id);
							$unread_count[$value->thread_id . '-' . $rec_value->user_id] = ($rec_value->unread_count > 0) ? 1 : 0;
							$is_deleted[$value->thread_id . '-' . $rec_value->user_id] = $rec_value->is_deleted;
						}
					}

					sort($current_recipients);

					$message = trim($value->message);
					$message = strip_tags($message);
					if ($message == '&nbsp;') {
						$message = '';
					}

					$aPostData = array(
						'post_author' => $value->sender_id,
						'post_date' => $value->date_sent,
						'post_date_gmt' => $value->date_sent,
						'post_content' => $message,
						'post_title' => '',
						'post_excerpt' => '',
						'post_status' => 'publish',
						'comment_status' => 'open',
						'ping_status' => 'open',
						'post_password' => '',
						'post_name' => '',
						'to_ping' => '',
						'pinged' => '',
						'post_modified' => $value->date_sent,
						'post_modified_gmt' => $value->date_sent,
						'post_content_filtered' => '',
						'post_parent' => 0,
						'guid' => '',
						'menu_order' => 0,
						'post_type' => 'peepso-message',
						'post_mime_type' => '',
						'comment_count' => 0
					);

					$post_id = wp_insert_post($aPostData);

					if ($value->thread_id != $prev_thread_id) {
						$prev_thread_id = $value->thread_id;

						if (in_array($current_recipients, $existing_recipients)) {
							// if same exact recipients means same conversation
							$parent_post_id = array_search($current_recipients, $existing_recipients);
						} else if (!in_array(intval($value->thread_id), $existing_thread_id)) {
							// if same thread id
							$parent_post_id = intval($post_id);
							$existing_thread_id[] = intval($value->thread_id);
							$existing_parent_post_id[intval($value->thread_id)] = $post_id;

							if (!in_array($current_recipients, $existing_recipients)) {
								$existing_recipients[$parent_post_id] = $current_recipients;
							}

							$sql = $wpdb->prepare("insert into " . $wpdb->prefix . "peepso_message_participants (`mpart_msg_id`, `mpart_user_id`) values ('%d', '%d')", $post_id, $value->sender_id);
							$wpdb->query($sql);

							foreach ($current_recipients as $recipient) {
								if ($recipient !== intval($value->sender_id)) {
									$sql = $wpdb->prepare("insert into " . $wpdb->prefix . "peepso_message_participants (`mpart_msg_id`, `mpart_user_id`) values ('%d', '%d')", $post_id, $recipient);
									$wpdb->query($sql);
								}
							}

							reset($current_recipients);
						}
					}

					$sql = $wpdb->prepare("update " . $wpdb->prefix . "posts set `post_name`= %d, `post_parent` = %d, `guid`= %s where `ID`=%d", $post_id, $parent_post_id, get_site_url() . 'peepso-message/' . intval($post_id), intval($post_id));
					$wpdb->query($sql);

					// insert recipients
					$sql = $wpdb->prepare("insert into " . $wpdb->prefix . "peepso_message_recipients (`mrec_msg_id`, `mrec_parent_id`, `mrec_user_id`, `mrec_viewed`, `mrec_deleted`) values (%d, %d, %d, %d, %d)", $post_id, $parent_post_id, $value->sender_id, ($unread_count[$value->thread_id . '-' . $value->sender_id] ?? 0), ($is_deleted[$value->thread_id . '-' . $value->sender_id] ?? 0));
					$wpdb->query($sql);

					foreach ($current_recipients as $recipient) {
						if ($recipient !== intval($value->sender_id)) {
							$sql = $wpdb->prepare("insert into " . $wpdb->prefix . "peepso_message_recipients (`mrec_msg_id`, `mrec_parent_id`, `mrec_user_id`, `mrec_viewed`, `mrec_deleted`) values (%d, %d, %d, %d, %d)", $post_id, $parent_post_id, $recipient, ($unread_count[$value->thread_id . '-' . $recipient] ?? 0), ($is_deleted[$value->thread_id . '-' . $recipient] ?? 0));
							$wpdb->query($sql);
						}
					}

					// insert activity
					$sql = $wpdb->prepare("insert into " . $wpdb->prefix . "peepso_activities (`act_owner_id`, `act_external_id`, `act_module_id`, `act_access`) values 
								(%d, %d, 6, 10)", $value->sender_id, $post_id);
					$wpdb->query($sql);

					
					// search for activity meta
					$sql = $wpdb->prepare("SELECT * FROM " . $wpdb->prefix . "bp_messages_meta WHERE message_id = %d", $value->id);
					$metas = $wpdb->get_results($sql);

					if ($metas) {
						foreach ($metas as $meta) {
							if ($meta->meta_key == '_gif_data') {
								// gif

								$data = unserialize($meta->meta_value);
								$gif = '';
								if (isset($data['mp4'])) {
									$gif = str_replace('.mp4', '.gif', $data['mp4']);
								} else if (isset($data['gif'])) {
									$gif = $$data['gif'];
								}

								if ($gif) {
									add_post_meta($post_id, 'peepso_giphy', $gif);
								}
							} else if ($meta->meta_key == 'bp_media_ids' && $this->photos) {
								// attachment id
								$attachment_ids = explode(',', $meta->meta_value);
								$act_id = $wpdb->get_var("SELECT act_id FROM " . $wpdb->prefix . "peepso_activities ORDER BY act_id DESC LIMIT 1");

								foreach ($attachment_ids as $attachment_id) {
									$media = $wpdb->get_row($wpdb->prepare("SELECT * FROM " . $wpdb->prefix . "bp_media WHERE id = %d", $attachment_id));
									
									if (is_object($media) && $media->type == 'photo') {
										$attachment = get_attached_file($media->attachment_id);

										$filename = basename($attachment);
										// get act id
										$_GET['type'] = $media->type;

										wp_set_current_user($value->sender_id);
										$user = PeepSoUser::get_instance($value->sender_id);

										$dir = $this->photos_model->get_photo_dir($value->sender_id, true);

										@mkdir($dir, 0755, TRUE);
										@mkdir($dir.'tmp', 0755, TRUE);

										$tmp_file = $this->photos_model->get_tmp_file($filename);


										$filetype = wp_check_filetype($tmp_file['path']);
										$filetype['ext'] = str_replace('jpeg', 'jpg', $filetype['ext']);
										$filehash = md5($tmp_file['name'] . time());
										$filename =  $filehash . '.' . $filetype['ext'];

										$tmp_file['path'] = str_replace($tmp_file['name'], $filename, $tmp_file['path']);
										$tmp_file['name'] = $filename;

										copy($attachment, $tmp_file['path']);
										$_GET['files'] = [$tmp_file['name']];

										do_action('peepso_activity_after_add_post', $post_id, $act_id);
										$_GET = NULL;
									}
								}
							}

						}
					}
				}
				$next_url = PeepsoMigrateBB::url('message&limit=' . $this->next_limit);
			}

			$this->counter = count($all_messages);
		}

		return array(
			'url' => $next_url,
			'class' => 'message',
			'counter' => $this->counter,
		);
	}

	function startMigrateProfileFields() {
		$next_url = PeepsoMigrateBB::url('group');

		// install core profile fields
		PeepSoProfileFields::install();
	
		/*
		#5418
		rename `description` field if `wp-biography` is exist
		*/
		global $wpdb;
		$description_field = $wpdb->get_row("SELECT * FROM " . $wpdb->prefix . "bp_xprofile_fields WHERE type = 'wp-biography'");
		if ($description_field) {
			$post = $wpdb->get_row("SELECT * FROM " . $wpdb->posts . " WHERE post_type = 'peepso_user_field' AND post_name = 'description'");
			wp_update_post(array(
				'ID' => $post->ID,
				'post_title' => $description_field->name
			));
		}
		
			
		if (PeepsoMigrateBB::plugin_check('profile_field')) {
			$gender_field = get_transient('peepso_migrate_gender_field');
			$gender_field_male = get_transient('peepso_migrate_gender_field_male');
			$gender_field_female = get_transient('peepso_migrate_gender_field_female');

			$birthdate_field = get_transient('peepso_migrate_birthdate_field');

			// get all profile fields, exclude name, gender, and birthdate
			if (!empty($gender_field) && !empty($gender_field_male) && !empty($gender_field_female)) {
				$sql = $wpdb->prepare("SELECT * FROM " . $wpdb->prefix . "bp_xprofile_fields WHERE parent_id = 0 AND id NOT IN (%d, %d, %d, 1, 2) AND type NOT IN ('wp-biography', 'wp-textbox', 'socialnetworks') ORDER BY id, group_id LIMIT %d, %d", 1, intval($gender_field), intval($birthdate_field), $this->limit, $this->per_page);
			} else {
				$sql = $wpdb->prepare("SELECT * FROM " . $wpdb->prefix . "bp_xprofile_fields WHERE parent_id = 0 AND id NOT IN (%d, %d, 1, 2) AND type NOT IN ('wp-biography', 'wp-textbox', 'socialnetworks') ORDER BY id, group_id LIMIT %d, %d", 1, intval($birthdate_field), $this->limit, $this->per_page);
			}

			$all_profile_fields = $wpdb->get_results($sql);

			// set default field order to add
			$field_order = 6;
			$last_field_order = 0;
			$current_group_id = 1;

			if (isset($all_profile_fields) && 0 < count($all_profile_fields)) {
				foreach ($all_profile_fields as $key => $value) {
					if (in_array($value->id, [1, 2])) {
						continue;
					}

					// check if same group
					if ($current_group_id != $value->group_id) {
						$current_group_id = $value->group_id;

						// get field group data
						$field_group = $wpdb->get_row($wpdb->prepare("SELECT * FROM " . $wpdb->prefix . "bp_xprofile_groups WHERE id = %d", $current_group_id));

						// add separator
						$aPostData = array(
							'post_author' => 1,
							'post_date' => current_time('mysql'),
							'post_date_gmt' => current_time('mysql'),
							'post_title' => $field_group->name,
							'post_content' => $field_group->name,
							'post_status' => 'publish',
							'comment_status' => 'closed',
							'ping_status' => 'closed',
							'post_parent' => 0,
							'guid' => get_bloginfo('url') . '/peepso_user_field/cpf/',
							'post_type' => 'peepso_user_field',
						);

						$post_id = wp_insert_post($aPostData);

						wp_update_post(array(
							'ID' => $post_id,
							'post_name' => $post_id
						));

						// postmeta
						$field_order = $last_field_order;
						$postmeta = array(
							'order' => $field_order,
							'class' => 'separator',
							'is_core' => 0,
							'default_title' => 1,
							'default_acc' => 10,
							'_wp_old_slug' => 'cpf',
							'method' => '_render',
							'method_form' => '_render_form_input',
						);

						// insert field postmeta
						foreach ($postmeta as $meta_key => $meta_val) {
							$wpdb->query($wpdb->prepare("INSERT INTO " . $wpdb->prefix . "postmeta (`post_id`, `meta_key`, `meta_value`) VALUES (%d, %s, %s)", $post_id, $meta_key, $meta_val));
						}
					}

					$aPostData = array(
						'post_author' => 1,
						'post_date' => current_time('mysql'),
						'post_date_gmt' => current_time('mysql'),
						'post_title' => $value->name,
						'post_content' => $value->name,
						'post_status' => 'publish',
						'comment_status' => 'closed',
						'ping_status' => 'closed',
						'post_parent' => 0,
						'guid' => get_bloginfo('url') . '/peepso_user_field/cpf/',
						'post_type' => 'peepso_user_field',
					);

					$post_id = wp_insert_post($aPostData);

					wp_update_post(array(
						'ID' => $post_id,
						'post_name' => $post_id
					));

					// default field postmeta
					$last_field_order = $value->field_order + $field_order;
					$postmeta = array(
						'order' => $last_field_order,
						'is_core' => 0,
						'_wp_old_slug' => 'cpf',
						'method' => '_render'
					);

					$this->add_memory('profile_field', $post_id, serialize(array(
						'value' => $value,
						'post_id' => $post_id,
						'postmeta' => $postmeta
					)));
				}

				$next_url = PeepsoMigrateBB::url('profile_field_value');
				if (isset($_GET['limit'])) {
					$next_url .= '&limit=' . sanitize_text_field($_GET['limit']);
				}
			}

			// append new option to core	
			// only if gender field, male option, female option is set
			if (!empty($gender_field) && !empty($gender_field_male) && !empty($gender_field_female)) {

				$sql = $wpdb->prepare("SELECT ID FROM " . $wpdb->prefix . "posts " .
						"WHERE post_name = %s AND post_type = %s AND post_status = %s", 'gender', 'peepso_user_field', 'publish');
				$peepso_gender_field = $wpdb->get_row($sql);

				$sql = $wpdb->prepare("SELECT A.name FROM " . $wpdb->prefix . "bp_xprofile_fields A " .
						"WHERE parent_id = %d AND type = %s AND id NOT IN ( %d, %d) ORDER BY id ASC", $gender_field, 'option', $gender_field_male, $gender_field_female);
				$all_custom_gender = $wpdb->get_results($sql);

				// append new option to core
				if ($peepso_gender_field !== FALSE && $all_custom_gender !== FALSE) {

					$list_of_gender = get_post_meta($peepso_gender_field->ID, 'select_options', true);

					for ($i = 1; $i <= count($all_custom_gender); $i++) {
						$gender_field_custom = get_transient('peepso_migrate_gender_field_custom' . ($i + 2));

						if (!empty($gender_field_custom)) {

							$sql = $wpdb->prepare("SELECT A.name FROM " . $wpdb->prefix . "bp_xprofile_fields A " .
									"WHERE id = %d AND type = %s AND id NOT IN ( %d, %d) ORDER BY id ASC", $gender_field_custom, 'option', $gender_field_male, $gender_field_female);
							$custom_field = $wpdb->get_row($sql);

							// $list_of_gender['c' . $gender_field_custom] = $custom_field->name;
							$option_name = 'option_' . $peepso_gender_field->ID . '_' . $i;
							$list_of_gender[$option_name] = $custom_field->name;
							$wpdb->query($wpdb->prepare("UPDATE $wpdb->usermeta SET meta_value = %s WHERE meta_key = %s AND meta_value = %s", $option_name, 'peepso_user_field_gender', 'c' . $gender_field_custom));
						}
					}

					update_post_meta($peepso_gender_field->ID, 'select_options', $list_of_gender);
				}
			}
		}

		return array(
			'url' => $next_url,
			'class' => 'profile_field',
			'counter' => 0,
		);
	}

	function startMigrateProfileFieldValue() {
		global $wpdb;

		$next_url = PeepsoMigrateBB::url('profile_field_user_data');
		if (isset($_GET['limit'])) {
			$next_url .= '&limit=' . sanitize_text_field($_GET['limit']);
		}

		$sql = $wpdb->prepare("SELECT * FROM " . $wpdb->prefix . "bp_peepso WHERE type = %s", 'profile_field');
		$all_profile_fields = $wpdb->get_results($sql);

		if (isset($all_profile_fields) && 0 < count($all_profile_fields)) {
			foreach ($all_profile_fields as $key => $item) {

				$new_id = unserialize($item->new_id);
				$value = $new_id['value'];
				$post_id = $new_id['post_id'];
				$postmeta = $new_id['postmeta'];

				// check if field is required
				if ($value->is_required == 1) {
					$postmeta['validation'] = serialize(array('required' => 1));
				}

				$profile_meta = $wpdb->get_results($wpdb->prepare("SELECT * FROM " . $wpdb->prefix . "bp_xprofile_meta WHERE object_id = %d", $value->id));
				if (isset($profile_meta) && count($profile_meta) > 0) {
					foreach ($profile_meta as $meta_key => $meta_value) {

						// check field visibility
						if ($meta_value->meta_key == 'default_visibility') {
							switch ($meta_value->meta_value) {
								case 'public' :
									$postmeta['default_acc'] = PeepSo::ACCESS_PUBLIC;
									break;
								case 'loggedin' :
									$postmeta['default_acc'] = PeepSo::ACCESS_MEMBERS;
									break;
								case 'friends' :
									if (class_exists('PeepSoFriendsPlugin')) {
										$postmeta['default_acc'] = PeepSoFriendsPlugin::ACCESS_FRIENDS;
									} else {
										$postmeta['default_acc'] = PeepSo::ACCESS_PUBLIC;
									}
									break;
								case 'adminsonly' :
									$postmeta['default_acc'] = PeepSo::ACCESS_PRIVATE;
									break;
							}
						}

						// check custom field visibility
						if ($meta_value->meta_key == 'allow_custom_visibility') {
							switch ($meta_value->meta_value) {
								case 'disabled' :
									$postmeta['user_disable_acc'] = 1;
									break;
								case 'allowed' :
									$postmeta['user_disable_acc'] = 0;
									break;
							}
						}
					}
				}

				// add additional postmeta into each field type
				switch ($value->type) {
					case 'selectbox':
					case 'multiselectbox' :
					case 'checkbox':
					case 'radio':
						$options = $wpdb->get_results($wpdb->prepare("SELECT * FROM " . $wpdb->prefix . "bp_xprofile_fields WHERE parent_id = %d ORDER BY option_order", $value->id));

						$select_options = array();
						$i = 1;
						if (isset($options) && count($options) > 0) {
							foreach ($options as $field_key => $field_value) {
								$select_options['option_' . $post_id . '_' . $i] = $field_value->name;
								$i++;
							}
						}

						$wpdb->query($wpdb->prepare("INSERT INTO " . $wpdb->prefix . "postmeta (post_id, meta_key, meta_value) VALUES (%d, %s, %s)", $post_id, 'select_options', serialize($select_options)));

						if ($value->type == 'selectbox') {
							$postmeta['class'] = 'selectsingle';
							$postmeta['method_form'] = '_render_form_select';
						} else if ($value->type == 'radio') {
							$postmeta['class'] = 'selectsingle';
							$postmeta['method_form'] = '_render_form_checklist';
						} else {
							$postmeta['class'] = 'selectmulti';
							$postmeta['method_form'] = '_render_form_checklist';
						}

						$this->add_memory('select_option', $post_id, serialize($select_options));
						break;
					case 'datebox' :
						$postmeta['class'] = 'textdate';
						$postmeta['method_form'] = '_render_form_input';
						break;
					case 'textbox' :
					case 'number' :
					case 'telephone' :
						$postmeta['class'] = 'text';
						$postmeta['method_form'] = '_render_form_input';
						break;
					case 'textarea' :
						$postmeta['class'] = 'text';
						$postmeta['method_form'] = '_render_form_textarea';
						break;
					case 'url' :
						$postmeta['class'] = 'texturl';
						$postmeta['method_form'] = '_render_form_input';
						break;
				}

				// insert field postmeta
				foreach ($postmeta as $meta_key => $meta_val) {
					$wpdb->query($wpdb->prepare("INSERT INTO " . $wpdb->prefix . "postmeta (`post_id`, `meta_key`, `meta_value`) VALUES (%d, %s, %s)", $post_id, $meta_key, $meta_val));
				}
			}
		}

		return array(
			'url' => $next_url,
			'class' => 'profile_field',
			'counter' => 0,
		);
	}

	function startMigrateProfileFieldUserData() {
		global $wpdb;

		$next_url = PeepsoMigrateBB::url('profile_field&limit=' . $this->next_limit);
		$sql = $wpdb->prepare("SELECT * FROM " . $wpdb->prefix . "bp_peepso WHERE type = %s", 'profile_field');
		$all_profile_fields = $wpdb->get_results($sql);

		if (isset($all_profile_fields) && 0 < count($all_profile_fields)) {
			foreach ($all_profile_fields as $key => $item) {

				$new_id = unserialize($item->new_id);
				$value = $new_id['value'];
				$post_id = $new_id['post_id'];
				$select_options = unserialize($this->get_memory('select_option', $post_id));

				// migrate user data
				$user_data = $wpdb->get_results($wpdb->prepare("SELECT * FROM " . $wpdb->prefix . "bp_xprofile_data WHERE field_id = %d", $value->id));
				if (isset($user_data) && count($user_data) > 0) {
					foreach ($user_data as $user_key => $user_value) {
						switch ($value->type) {
							case 'multiselectbox' :
							case 'checkbox':
							case 'selectbox':
							case 'radio' :
								$selected_user_options = array();

								if ($value->type == 'selectbox' || $value->type == 'radio') {
									$selected_user_options_old = array($user_value->value);
								} else {
									$selected_user_options_old = unserialize($user_value->value);
								}
								foreach ($select_options as $option_key => $option_value) {
									if (in_array($option_value, $selected_user_options_old)) {
										$selected_user_options[] = $option_key;
									}
								}

								if ($value->type == 'radio' || $value->type == 'selectbox') {
									$selected_user_options = $selected_user_options[0];
								} else {
									$selected_user_options = serialize($selected_user_options);
								}
								break;
							case 'datebox' :
								$selected_user_options = str_replace(' 00:00:00', '', $user_value->value);
								break;
							default :
								$selected_user_options = $user_value->value;
								break;
						}

						$wpdb->query($wpdb->prepare("INSERT INTO " . $wpdb->prefix . "usermeta (user_id, meta_key, meta_value) VALUES (%d, %s, %s)", $user_value->user_id, 'peepso_user_field_' . $post_id, $selected_user_options));

						// update accessibility for custom profile fields
						$custom_acc = $this->_get_field_visibility($user_value->user_id, $value->id);
						update_user_meta($user_value->user_id, 'peepso_user_field_' . $post_id . '_acc', $custom_acc);
					}
				}
			}

			$this->counter = count($all_profile_fields);
		}

		$sql = $wpdb->prepare("delete from " . $wpdb->prefix . "bp_peepso where type = %s", 'profile_field');
		$wpdb->query($sql);

		return array(
			'url' => $next_url,
			'class' => 'profile_field',
			'counter' => $this->counter,
		);
	}

	function startMigrateGroups() {
		$next_url = PeepsoMigrateBB::url('group_member');

		if (PeepsoMigrateBB::plugin_check('group')) {
			register_post_type('peepso-group');
			/*
			  NOT DONE YET :

			  MIGRATE GROUP PRIVACY
			  GENERATE GROUP URL

			 */
			global $wpdb;

			$sql = $wpdb->prepare("SELECT * FROM " . $wpdb->prefix . "bp_groups limit %d, %d", $this->limit, $this->per_page);
			$all_groups = $wpdb->get_results($sql);

			if (isset($all_groups) && 0 < count($all_groups)) {
				foreach ($all_groups as $key => $value) {

					$aPostData = array(
						'post_author' => $value->creator_id,
						'post_date' => $value->date_created,
						'post_date_gmt' => $value->date_created,
						'post_title' => $value->name,
						'post_content' => $value->description,
						'post_status' => 'publish',
						'comment_status' => 'closed',
						'ping_status' => 'closed',
						'post_parent' => 0,
						'post_type' => 'peepso-group',
					);

					$post_id = wp_insert_post($aPostData);

					$this->add_memory('group', $value->id, $post_id);

					$sql = "SELECT count(*) as total FROM " . $wpdb->prefix . "bp_groups_members where is_confirmed = 1 and is_banned = 0 and group_id = " . $value->id;
					$total_result = $wpdb->get_results($sql);
					$total_group_members = $total_result["0"]->total;
					add_post_meta($post_id, 'peepso_group_members_count', $total_group_members);
					
					$group_privacy = 0;
					if ($value->status == 'private') {
						$group_privacy = 1;
					} else if ($value->status == 'hidden') {
						$group_privacy = 2;
					}
					add_post_meta($post_id, 'peepso_group_privacy', $group_privacy);
				}

				$next_url = PeepsoMigrateBB::url('group&limit=' . $this->next_limit);
			}

			$this->counter = count($all_groups);
		}

		return array(
			'url' => $next_url,
			'class' => 'group',
			'counter' => $this->counter,
		);
	}

	function startMigrateGroupMembers() {
		$next_url = PeepsoMigrateBB::url('group_avatar');

		if (PeepsoMigrateBB::plugin_check('group')) {
			global $wpdb;

			$sql = $wpdb->prepare("SELECT A.*, B.creator_id FROM " . $wpdb->prefix . "bp_groups_members A LEFT JOIN " . $wpdb->prefix . "bp_groups B ON A.group_id = B.id limit %d, %d", $this->limit, $this->per_page);
			$all_group_members = $wpdb->get_results($sql);

			if (isset($all_group_members) && 0 < count($all_group_members)) {
				foreach ($all_group_members as $key => $value) {

					if ($value->user_id == $value->creator_id) {
						$user_status = 'member_owner';
					} else if ($value->is_admin == 1) {
						$user_status = 'member_manager';
					} else if ($value->is_mod == 1) {
						$user_status = 'member_moderator';
					} else if ($value->is_banned == 1) {
						$user_status = 'banned';
					} else if ($value->is_confirmed == 1) {
						$user_status = 'member';
					} else {
						$user_status = 'pending_user';
					}

					$wpdb->query($wpdb->prepare("INSERT INTO " . $wpdb->prefix . "peepso_group_members (gm_user_id, gm_group_id, gm_user_status, gm_joined) VALUES (%d, %d, %s, %s)", $value->user_id, $this->get_memory('group', $value->group_id), $user_status, $value->date_modified));
				}

				$next_url = PeepsoMigrateBB::url('group_member&limit=' . $this->next_limit);
			}

			$this->counter = count($all_group_members);
		}

		return array(
			'url' => $next_url,
			'class' => 'group_member',
			'counter' => $this->counter,
		);
	}

	function startMigrateGroupAvatars() {
		$next_url = PeepsoMigrateBB::url('group_activity');
		if ($this->photos) {
			$next_url = PeepsoMigrateBB::url('group_album');
		}

		if (PeepsoMigrateBB::plugin_check('group')) {
			global $wpdb;

			$sql = $wpdb->prepare("SELECT * FROM " . $wpdb->prefix . "bp_groups limit %d, %d", $this->limit, $this->per_page);
			$all_groups = $wpdb->get_results($sql);

			@mkdir($this->peepso_dir);
			$target_dir = $this->peepso_dir . 'groups';
			@mkdir($target_dir);

			$upload_dir = wp_upload_dir();
			$upload_path = $upload_dir['basedir'] . DIRECTORY_SEPARATOR;

			if (isset($all_groups) && 0 < count($all_groups)) {
				$path = get_home_path();

				foreach ($all_groups as $key => $group) {
					$new_group_id = $this->get_memory('group', $group->id);
					PeepSoGroupsPlugin::get_instance()->action_setup_group_album($new_group_id);

					if (is_dir($upload_path . "group-avatars" . DIRECTORY_SEPARATOR . $group->id)) {
						$buddy_avatars = scandir($upload_path . "group-avatars" . DIRECTORY_SEPARATOR . $group->id);
						if (isset($buddy_avatars) && 0 < count($buddy_avatars)) {
							$use_custom_avatar = FALSE;

							foreach ($buddy_avatars as $poz => $file) {
								if ("." != $file && ".." != $file && "" != $file) {
									@mkdir($target_dir . DIRECTORY_SEPARATOR . $new_group_id);
									if (FALSE !== strpos($file, "bpfull")) {
										$file_array = explode(".", $file);
										$extension = $file_array[count($file_array) - 1];

										$source = $upload_path . "group-avatars" . DIRECTORY_SEPARATOR . $group->id . DIRECTORY_SEPARATOR . $file;
										$destination1 = $target_dir . DIRECTORY_SEPARATOR . $new_group_id . DIRECTORY_SEPARATOR . 'avatar-full.jpg';
										$destination2 = $target_dir . DIRECTORY_SEPARATOR . $new_group_id . DIRECTORY_SEPARATOR . 'avatar-orig.jpg';

										if ($extension == 'png') {
											$this->_png2jpg($source, $destination1);
											$this->_png2jpg($source, $destination2);
										} else if ($extension == 'webp') {
											$this->_webp2jpg($source, $destination1);
											$this->_webp2jpg($source, $destination2);
										} else {
											copy($source, $destination1);
											copy($source, $destination2);
										}

										$use_custom_avatar = TRUE;

										if ($this->photos) {
											$this->save_avatar_and_cover_group($group->creator_id, $group->id, 'avatar', $destination2);
										}
									} else if (FALSE !== strpos($file, "bpthumb")) {
										$file_array = explode(".", $file);
										$extension = $file_array[count($file_array) - 1];

										$source = $upload_path . "group-avatars" . DIRECTORY_SEPARATOR . $group->id . DIRECTORY_SEPARATOR . $file;
										$destination = $target_dir . DIRECTORY_SEPARATOR . $new_group_id . DIRECTORY_SEPARATOR . 'avatar.jpg';

										if ($extension == 'png') {
											$this->_png2jpg($source, $destination);
										} else if ($extension == 'webp') {
											$this->_webp2jpg($source, $destination);
										} else {
											copy($source, $destination);
										}

										$use_custom_avatar = TRUE;
									}
								}
							}

							if ($use_custom_avatar) {
								add_post_meta($new_group_id, 'group_avatar_custom', 1);
							}
						}
					}

					if (is_dir($upload_path . "buddypress" . DIRECTORY_SEPARATOR . "groups" . DIRECTORY_SEPARATOR . $group->id . DIRECTORY_SEPARATOR . "cover-image")) {
						$buddy_cover = scandir($upload_path . "buddypress" . DIRECTORY_SEPARATOR . "groups" . DIRECTORY_SEPARATOR . $group->id . DIRECTORY_SEPARATOR . "cover-image");

						if (isset($buddy_cover) && 0 < count($buddy_cover)) {
							foreach ($buddy_cover as $poz => $file) {
								if ("." != $file && ".." != $file && "" != $file) {
									$new_group_id = $this->get_memory('group', $group->id);
									@mkdir($target_dir . DIRECTORY_SEPARATOR . $new_group_id);
									if (FALSE !== strpos($file, "bp-cover-image")) {
										$file_array = explode(".", $file);
										$extension = $file_array[count($file_array) - 1];

										$source = $upload_path . "buddypress" . DIRECTORY_SEPARATOR . "groups" . DIRECTORY_SEPARATOR . $group->id . DIRECTORY_SEPARATOR . "cover-image" . DIRECTORY_SEPARATOR . $file;
										$destination = $target_dir . DIRECTORY_SEPARATOR . $new_group_id . DIRECTORY_SEPARATOR . 'cover.jpg';

										if ($extension == 'png') {
											$this->_png2jpg($source, $destination);
										} else if ($extension == 'webp') {
											$this->_webp2jpg($source, $destination);
										} else {
											copy($source, $destination);
										}

										add_post_meta($new_group_id, 'group_cover_photo', PeepSo::get_peepso_uri() . 'groups/' . $new_group_id . '/cover.jpg');

										if ($this->photos) {
											$this->save_avatar_and_cover_group($group->creator_id, $group->id, 'cover', $destination);
										}
									}
								}
							}
						}
					}
				}

				$next_url = PeepsoMigrateBB::url('group_avatar&limit=' . $this->next_limit);
			}

			$this->counter = count($all_groups);
		}

		return array(
			'url' => $next_url,
			'class' => 'group_avatar',
			'counter' => $this->counter,
		);
	}

	function startMigrateGroupAlbum() {
		$next_url = PeepsoMigrateBB::url('group_activity');

		if (PeepsoMigrateBB::plugin_check('group') && class_exists('PeepSoSharePhotos')) {
			global $wpdb;

			$sql = $wpdb->prepare("SELECT * FROM " . $wpdb->prefix . "bp_media_albums where `group_id` > 0 limit %d, %d", $this->limit, $this->per_page);
			$all_album = $wpdb->get_results($sql);

			if (isset($all_album) && 0 < count($all_album)) {
				foreach ($all_album as $key => $album) {
					add_filter('peepso_photos_filter_owner_album',	array(PeepSoGroupsPlugin::get_instance(), 'filter_photos_owner_album'));
					add_action('peepso_activity_after_add_post', 	array(PeepSoGroupsPlugin::get_instance(), 'after_add_post'), 10, 2);
					add_action('peepso_activity_after_add_post', array(PeepSoSharePhotos::get_instance(), 'after_add_post_album'), 10, 2);
					add_filter('peepso_activity_allow_empty_content', array(PeepSoSharePhotos::get_instance(), 'activity_allow_empty_content'), 10, 1);
					add_filter('peepso_photos_dir_' . PeepSoGroupsPlugin::MODULE_ID, function($photo_dir) use ($album){
						$group = new PeepSoGroup($this->get_memory('group', $album->group_id));
						if(FALSE !== $group) {
							$photo_dir =  ($group) ? $group->get_image_dir() : '';
							$photo_dir .=  'photos/';
						}
	
						return $photo_dir;
					});

					$_GET = array();
					$_GET['user_id'] = $album->user_id;
					$_GET['name'] = $album->title;
					$_GET['privacy'] = PeepSo::ACCESS_PUBLIC;
					$_GET['description'] = '';
					$_GET['module_id'] = PeepSoGroupsPlugin::MODULE_ID;
					$_GET['group_id'] = $this->get_memory('group', $album->group_id);
					$_GET['type'] = 'album';

					wp_set_current_user($album->user_id);
					$owner = $album->user_id;
					$name = $album->title;
					$privacy = PeepSo::ACCESS_PUBLIC;
					$description = $album->title;

					$sql = $wpdb->prepare("SELECT * FROM " . $wpdb->prefix . "bp_media where `group_id` > 0 and album_id = %d", $album->id);
					$all_files = $wpdb->get_results($sql);
					$files = array();				
					foreach ($all_files as $key => $media) {
						$attachment = get_attached_file($media->attachment_id);
						$filename = basename($attachment);

						$dir = $this->photos_model->get_photo_dir($album->user_id, true);
						@mkdir($dir, 0755, TRUE);
						@mkdir($dir.'tmp', 0755, TRUE);

						$tmp_file = $this->photos_model->get_tmp_file($filename);
						$filetype = wp_check_filetype($tmp_file['path']);
						$filetype['ext'] = str_replace('jpeg', 'jpg', $filetype['ext']);
						$filehash = md5($tmp_file['name'] . time());
						$filename =  $filehash . '.' . $filetype['ext'];

						$tmp_file['path'] = str_replace($tmp_file['name'], $filename, $tmp_file['path']);
						$tmp_file['name'] = $filename;
						
						@copy($attachment, $tmp_file['path']);
						array_push($files, $tmp_file['name']);
					}
					$_GET['photo'] = $files;

					// module, extends for groups / page / events
					$module_id = PeepSoGroupsPlugin::MODULE_ID;

					if (count($files) > 0) {
						// create post
						$content = '';
						$extra = array(
							'module_id' => PeepSoSharePhotos::MODULE_ID,
							'act_access' => $privacy,
							'post_date' => $album->date_created,
							'post_date_gmt' => $album->date_created,
						);

						// create post
						$peepso_activity = PeepSoActivity::get_instance();
						$post_id = $peepso_activity->add_post($owner, $owner, $content, $extra);
						add_post_meta($post_id, PeepSoSharePhotos::POST_META_KEY_PHOTO_TYPE, PeepSoSharePhotos::POST_META_KEY_PHOTO_TYPE_ALBUM, true);
						add_post_meta($post_id, PeepSoSharePhotos::POST_META_KEY_PHOTO_COUNT, count($files), true);

						$this->add_memory('group_album', $album->id, $post_id);
						$album_activity = $wpdb->get_row($wpdb->prepare("SELECT activity_id FROM " . $wpdb->prefix . "bp_activity_meta WHERE meta_key = 'bp_media_album_activity' AND meta_value = %d", $album->id));
						if ($album_activity) {
							$this->add_memory('activity', $album_activity->activity_id, $post_id);
							$this->add_memory('activity_module', $album_activity->activity_id, PeepSoSharePhotos::MODULE_ID);
							$this->add_memory('activity_owner', $album_activity->activity_id, $owner);

							// search for activity meta
							$sql = $wpdb->prepare("SELECT meta_value FROM " . $wpdb->prefix . "bp_activity_meta WHERE meta_key = 'bp_favorite_users' AND activity_id = %d", $album_activity->activity_id);
							$likes = $wpdb->get_row($sql);
							if ($likes) {
								$users_like = unserialize($likes->meta_value);
	
								foreach ($users_like as $user_id) {
									$wpdb->insert($wpdb->prefix . 'peepso_likes', [
										'like_user_id'     => $user_id,
										'like_external_id' => $post_id,
										'like_module_id'   => PeepSoSharePhotos::MODULE_ID,
										'like_type'        => 1,
										'like_timestamp'   => current_time('timestamp')
									]);
								}
							}
						}
					}
				}

				$next_url = PeepsoMigrateBB::url('group_album&limit=' . $this->next_limit);
			}

			$this->counter = count($all_album);
		}

		return array(
			'url' => $next_url,
			'class' => 'group_album',
			'counter' => $this->counter,
		);
	}

	function startMigrateGroupActivity() {
		$next_url = PeepsoMigrateBB::url('unpublish');

		if (PeepsoMigrateBB::plugin_check('group')) {
			global $wpdb;

			$sql = $wpdb->prepare("SELECT * FROM " . $wpdb->prefix . "bp_activity where `component` = %s or `type` = %s limit %d, %d", 'groups', 'activity_comment', $this->limit, $this->per_page);
			$all_activities = $wpdb->get_results($sql);

			if (isset($all_activities) && 0 < count($all_activities)) {
				if ($this->photos) {
					add_action('peepso_activity_after_add_post', array(PeepSoSharePhotos::get_instance(), 'after_add_post'), 20, 2);
					add_action('peepso_activity_after_save_comment', array(PeepSoSharePhotos::get_instance(), 'after_save_comment'), 20, 2);
				}
				if (class_exists('PeepSoVideos')) {
					add_action('peepso_activity_after_add_post', array(PeepSoVideos::get_instance(), 'after_add_post'), 20, 2);
					$videos_model = new PeepSoVideosModel();
				}
				add_action('peepso_activity_after_add_post', 	array(PeepSoGroupsPlugin::get_instance(), 'after_add_post'), 10, 2);
				add_filter('peepso_photos_stream_photos_album',	array(PeepSoGroupsPlugin::get_instance(), 'photos_stream_photos_album'));

				foreach ($all_activities as $key => $post) {
					// Skip if it's groups update activity
					if (in_array($post->type, array('created_group', 'joined_group'))) {
						continue;
					}

					// Skip if it's groups photos update
					if ($post->privacy == 'media') {
						continue;
					}

					// check if previous activity already migrated
					$check = $this->get_memory('activity', $post->id);
					if (!empty($check)) {
						continue;
					}

					$post_type = 'peepso-post';

					if ($post->type == 'activity_comment') {
						$post_type = 'peepso-comment';
					}

					$post_content = strip_tags($post->content);

					if (empty($post_content) && $post->component != 'activity') {
						continue;
					}

					// convert tags
					if (class_exists('PeepSoTags')) {
						preg_match_all("/\@(\w+)/", $post_content, $matches);
						if (count($matches[1]) > 0) {
							foreach ($matches[1] as $username) {
								$user = get_user_by('slug', $username);

								if ($user) {
									$post_content = str_replace('@' . $username, '[peepso_tag id=' . $user->ID . ']' . $username . '[/peepso_tag]', $post_content);
								}
							}
						}
					}

					$timestamp = strtotime($post->date_recorded);

					$aPostData = array(
						'post_author' => $post->user_id,
						'post_date' => $post->date_recorded,
						'post_date_gmt' => $post->date_recorded,
						'post_content' => $post_content,
						'post_title' => $post->user_id . "-" . $post->user_id . "-" . $timestamp,
						'post_excerpt' => $post_content,
						'post_status' => 'publish',
						'comment_status' => 'open',
						'ping_status' => 'open',
						'post_password' => '',
						'post_name' => $post->user_id . "-" . $post->user_id . "-" . $timestamp,
						'to_ping' => '',
						'pinged' => '',
						'post_modified' => $post->date_recorded,
						'post_modified_gmt' => $post->date_recorded,
						'post_content_filtered' => '',
						'post_parent' => 0,
						'guid' => get_site_url() . '/' . $post_type . '/' . $post->user_id . "-" . $post->user_id . "-" . $timestamp . '/',
						'menu_order' => 0,
						'post_type' => $post_type,
						'post_mime_type' => '',
						'comment_count' => 0
					);

					$peepso_new_post_id = wp_insert_post($aPostData);
					$this->add_memory('activity', $post->id, $peepso_new_post_id);

					$module_id = 1;
					$group_id = $this->get_memory('group', $post->item_id);
					if ($post->type == 'activity_comment') {
						$bp_peepso_parent_id = $this->get_memory('activity', $post->item_id);

						$sql = "SELECT A.id, A.item_id, @pv:=A.secondary_item_id AS parent FROM (select * from " . $wpdb->prefix . "bp_activity ORDER BY id DESC) A JOIN (SELECT @pv:=$post->secondary_item_id) tmp WHERE A.id=@pv";
						$parents = $wpdb->get_results($sql);

						if (count($parents) > 0) {
							foreach ($parents as $p) {
								if ($p->parent == $post->item_id) {
									$bp_peepso_parent_id = $this->get_memory('activity', $p->id);
								}

								if ($p->parent == 0) {
									$group_id = $this->get_memory('group', $p->item_id);
								}
							}
						}

						$bp_peepso_parent_module_id = $this->get_memory('activity_module', $post->item_id);
						if (!empty($bp_peepso_parent_module_id)) {
							$module_id = $bp_peepso_parent_module_id;
						}

						$comment_author = $post->user_id;
						$bp_peepso_parent_owner = $this->get_memory('activity_owner', $post->item_id);
						if (!empty($bp_peepso_parent_owner)) {
							$comment_author = $bp_peepso_parent_owner;
						}

						// if regular comment
						if ($post->item_id == $post->secondary_item_id) {
							$sql = $wpdb->prepare("insert into " . $wpdb->prefix . "peepso_activities (`act_owner_id`, `act_external_id`, `act_has_replies`, `act_comment_object_id`, `act_comment_module_id`, `act_module_id`) values ('%d', '%d', '1', '%d', '%d', '1')", $comment_author, intval($peepso_new_post_id), $bp_peepso_parent_id, $module_id);
							$wpdb->query($sql);
						} else {
							$sql = $wpdb->prepare("insert into " . $wpdb->prefix . "peepso_activities (`act_owner_id`, `act_external_id`, `act_has_replies`, `act_comment_object_id`, `act_comment_module_id`, `act_module_id`) values ('%d', '%d', '1', '%d', '%d', '1')", $comment_author, intval($peepso_new_post_id), $bp_peepso_parent_id, $module_id);
							$wpdb->query($sql);
						}
					} else {
						$sql = $wpdb->prepare("insert into " . $wpdb->prefix . "peepso_activities (`act_owner_id`, `act_external_id`, `act_has_replies`, `act_comment_object_id`, `act_comment_module_id`, `act_module_id`) values ('%d', '%d', '0', '0', '0', '1')", $post->user_id, intval($peepso_new_post_id));
						$wpdb->query($sql);
					}

					if ($post_type == 'peepso-post') {
						$this->save_link_preview($peepso_new_post_id, $post_content);
					}

					// search for activity meta
					$sql = $wpdb->prepare("SELECT * FROM " . $wpdb->prefix . "bp_activity_meta WHERE activity_id = %d", $post->id);
					$metas = $wpdb->get_results($sql);

					if ($metas) {
						foreach ($metas as $meta) {
							if ($meta->meta_key == 'bp_favorite_users') {
								$users_like = unserialize($meta->meta_value);
								
								$bp_peepso_parent_module_id = $this->get_memory('activity_module', $post->id);
								if (!empty($bp_peepso_parent_module_id)) {
									$module_id = $bp_peepso_parent_module_id;
								}

								foreach ($users_like as $user_id) {
									$wpdb->insert($wpdb->prefix . 'peepso_likes', [
										'like_user_id'     => $user_id,
										'like_external_id' => $peepso_new_post_id,
										'like_module_id'   => $module_id,
										'like_type'        => 1,
										'like_timestamp'   => current_time('timestamp')
									]);
								}

							} else if ($meta->meta_key == '_gif_data') {
								// gif

								$data = unserialize($meta->meta_value);
								$gif = '';
								if (isset($data['mp4'])) {
									$gif = str_replace('.mp4', '.gif', $data['mp4']);
								} else if (isset($data['gif'])) {
									$gif = $$data['gif'];
								}

								if ($gif) {
									add_post_meta($peepso_new_post_id, 'peepso_giphy', $gif);
								}
							} else if (($meta->meta_key == 'bp_media_ids' || $meta->meta_key == 'bp_video_ids') && ($this->photos || class_exists('PeepSoVideos'))) {
								// attachment id
								$attachment_ids = explode(',', $meta->meta_value);
								$activity = $wpdb->get_row("SELECT * FROM " . $wpdb->prefix . "peepso_activities ORDER BY act_id DESC LIMIT 1");
								$act_id = $activity->act_id;

								foreach ($attachment_ids as $attachment_id) {
									$media = $wpdb->get_row($wpdb->prepare("SELECT * FROM " . $wpdb->prefix . "bp_media WHERE id = %d", $attachment_id));

									if (!is_object($media)) continue;

									// skip if an album
									if ($media->album_id > 0 && $media->type == 'photo') {
										continue;
									}

									// skip if it's not from groups
									if ($media->group_id == 0) {
										continue;
									}
									
									if ($media->type == 'photo' || $media->type == 'video') {
										$attachment = get_attached_file($media->attachment_id);
										$filename = basename($attachment);
										// get act id
										$_GET['group_id'] = $group_id;

										if ($media->type == 'photo' && class_exists('PeepSoSharePhotos')) {
											if ($post_type == 'peepso-post') {
												add_filter('peepso_photos_dir_' . PeepSoGroupsPlugin::MODULE_ID, function($photo_dir) use ($group_id){
													$group = new PeepSoGroup($group_id);
													if(FALSE !== $group) {
														$photo_dir =  ($group) ? $group->get_image_dir() : '';
														$photo_dir .=  'photos/';
													}
								
													return $photo_dir;
												});

												$_GET['module_id'] = 8;
												$wpdb->query($wpdb->prepare("UPDATE " . $wpdb->prefix . "peepso_activities SET act_module_id = %d WHERE act_id = %d", 4, $act_id));
											} else {
												add_filter('peepso_photos_dir_' . PeepSoGroupsPlugin::MODULE_ID, array(PeepSoGroupsPlugin::get_instance(), 'photos_groups_dir'));
											}

											wp_set_current_user($post->user_id);
											$_GET['type'] = 'photo';

											PeepSoGroupsPlugin::get_instance()->action_setup_group_album($group_id);
											$dir = $this->photos_model->get_photo_dir($post->user_id, true);
											@mkdir($dir, 0755, TRUE);
											@mkdir($dir.'tmp', 0755, TRUE);

											$tmp_file = $this->photos_model->get_tmp_file($filename);
											$filetype = wp_check_filetype($tmp_file['path']);
											$filetype['ext'] = str_replace('jpeg', 'jpg', $filetype['ext']);
											$filehash = md5($tmp_file['name'] . time());
											$filename =  $filehash . '.' . $filetype['ext'];

											$tmp_file['path'] = str_replace($tmp_file['name'], $filename, $tmp_file['path']);
											if ($post_type != 'peepso-post') {
												$tmp_file['path'] = str_replace('groups' . DIRECTORY_SEPARATOR . $group_id, 'users' . DIRECTORY_SEPARATOR . $post->user_id, $tmp_file['path']);
											}
											$tmp_file['name'] = $filename;

											copy($attachment, $tmp_file['path']);
											if ($post_type == 'peepso-post') {
												$_GET['files'] = [$tmp_file['name']];
											} else {
												$_GET['photo'] = $tmp_file['name'];
											}

											$this->add_memory('activity_module', $post->id, PeepSoSharePhotos::MODULE_ID);
											$this->add_memory('activity_owner', $post->id, $post->user_id);
										} else if ($media->type == 'video' && class_exists('PeepSoVideos')) {
											$wpdb->query($wpdb->prepare("UPDATE " . $wpdb->prefix . "peepso_activities SET act_module_id = %d WHERE act_id = %d", 5, $act_id));

											$dir = $videos_model->get_video_dir($post->user_id);
											if (!is_dir($dir)) {
												mkdir($dir, 0755, TRUE);
											}

											$tmp_file = $videos_model->get_tmp_file($filename);
											$filetype = wp_check_filetype($tmp_file['path'], PeepSoVideosUpload::$allowed_mime_types);
											$filehash = md5($tmp_file['name'] . time());
											$filename =  $filehash . '.' . $filetype['ext'];
								
											$tmp_file['path'] = str_replace($tmp_file['name'], $filename, $tmp_file['path']);
											$tmp_file['name'] = $filename;
								
											copy($attachment, $tmp_file['path']);
											$_GET['type'] = 'video';
											$_GET['video_title'] = $filename;
											$_GET['video'] = $tmp_file['name'];
											$_GET['module_id'] = 8;
										}

										if ($post_type == 'peepso-post') {
											do_action('peepso_activity_after_add_post', $peepso_new_post_id, $act_id);
										} else {
											do_action('peepso_activity_after_save_comment', $peepso_new_post_id, $activity);
										}
										$_GET = NULL;
									}
								}
							}
						}
					}


					add_post_meta($peepso_new_post_id, '_peepso_display_link_preview', 1);
					add_post_meta($peepso_new_post_id, 'peepso_group_id', $group_id);
				}

				$next_url = PeepsoMigrateBB::url('group_activity&limit=' . $this->next_limit);
			}

			$this->counter = count($all_activities);
		}


		return array(
			'url' => $next_url,
			'class' => 'group_activity',
			'counter' => $this->counter,
		);
	}

	function unpublishBuddyBoss() {
		global $wpdb;

		update_option('peepso_migrated_from', 'buddyboss');

		$sql = "update " . $wpdb->prefix . "posts set `post_content`='[peepso_activity]' where `post_type`='page' and `post_name`='activity'";
		$wpdb->query($sql);

		$sql = "update " . $wpdb->prefix . "posts set `post_content`='[peepso_members]' where `post_type`='page' and `post_name`='members'";
		$wpdb->query($sql);

		$sql = "update " . $wpdb->prefix . "posts set `post_content`='[peepso_profile]' where `post_type`='page' and `post_name`='profile'";
		$wpdb->query($sql);

		$sql = "update " . $wpdb->prefix . "posts set `post_content`='[peepso_register]' where `post_type`='page' and `post_name`='register'";
		$wpdb->query($sql);

		$sql = "update " . $wpdb->prefix . "posts set `post_content`='[peepso_recover]' where `post_type`='page' and `post_name`='password-recover'";
		$wpdb->query($sql);

		$sql = "update " . $wpdb->prefix . "posts set `post_content`='[peepso_groups]' where `post_type`='page' and `post_name`='groups'";
		$wpdb->query($sql);

		$sql = "DROP TABLE " . $wpdb->prefix . "bp_peepso";
		$wpdb->query($sql);

		if (!defined('SKIP_DEACTIVATE')) {
			$this->deactivatePlugins();
		}

		return array(
			'finished' => 1,
			'counter' => $this->counter,
		);
	}

	function deactivatePlugins() {
		global $wpdb;

		$sql = "SELECT `option_value` FROM " . $wpdb->prefix . "options where `option_name`='active_plugins'";
		$option_value = $wpdb->get_results($sql);

		if (isset($option_value) && isset($option_value["0"])) {
			$option_value = $option_value["0"]->option_value;
			$option_value = unserialize($option_value);

			if (isset($option_value) && 0 < count($option_value)) {
				$temp = array();
				foreach ($option_value as $key => $value) {
					if (FALSE === strpos(" " . $value, "buddyboss") && FALSE === strpos(" " . $value, "peepsomigrate")) {
						$temp[] = $value;
					}
				}
				$option_value = $temp;
			}

			$sql = $wpdb->prepare("update " . $wpdb->prefix . "options set `option_value`='%s' where `option_name`='active_plugins'", serialize($option_value));
			$wpdb->query($sql);
		}
	}

	function deletePeepSoContent() {
		global $wpdb;

		$sql = "delete from " . $wpdb->prefix . "peepso_activities";
		$wpdb->query($sql);

		$sql = "delete from " . $wpdb->prefix . "peepso_likes";
		$wpdb->query($sql);

		if (class_exists('PeepSoFriendsPlugin')) {
			$sql = "delete from " . $wpdb->prefix . "peepso_friends";
			$wpdb->query($sql);

			$sql = "delete from " . $wpdb->prefix . "peepso_friend_requests";
			$wpdb->query($sql);
		}

		if (class_exists('PeepSoMessagesPlugin')) {
			$sql = "delete from " . $wpdb->prefix . "peepso_message_participants";
			$wpdb->query($sql);

			$sql = "delete from " . $wpdb->prefix . "peepso_message_recipients";
			$wpdb->query($sql);
		}

		if (class_exists('PeepSoGroupsPlugin')) {
			$sql = "delete from " . $wpdb->prefix . "peepso_group_members";
			$wpdb->query($sql);
		}

		if ($this->photos) {
			$sql = "delete from " . $wpdb->prefix . "peepso_photos";
			$wpdb->query($sql);

			$sql = "delete from " . $wpdb->prefix . "peepso_photos_album";
			$wpdb->query($sql);
		}

		if (class_exists('PeepSoVideos')) {
			$sql = "delete from " . $wpdb->prefix . "peepso_videos";
			$wpdb->query($sql);
		}

		$sql = "delete from " . $wpdb->prefix . "peepso_notifications";
		$wpdb->query($sql);

		$sql = "delete from " . $wpdb->prefix . "peepso_users";
		$wpdb->query($sql);

		$sql = "delete from " . $wpdb->prefix . "posts where `post_type` like ('%peepso%')";
		$wpdb->query($sql);

		$sql = "delete from " . $wpdb->prefix . "postmeta where `meta_key` like '%peepso%'";
		$wpdb->query($sql);

		$sql = "delete from " . $wpdb->prefix . "usermeta where `meta_key` like '%peepso%'";
		$wpdb->query($sql);

		$sql = 'CREATE TABLE IF NOT EXISTS ' . $wpdb->prefix . 'bp_peepso (
		  `id` bigint(20) NOT NULL AUTO_INCREMENT,
		  `type` TEXT NOT NULL,
		  `old_id` TEXT NOT NULL,
		  `new_id` TEXT NOT NULL,
		  PRIMARY KEY (`id`)
		) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
		';
		$wpdb->query($sql);

		require_once (ABSPATH . 'wp-admin/includes/class-wp-filesystem-base.php');
		require_once (ABSPATH . 'wp-admin/includes/class-wp-filesystem-direct.php');
		$fs = new WP_Filesystem_Direct(false);
		$fs->rmdir(WP_CONTENT_DIR . '/peepso', true);

		return array(
			'url' => PeepsoMigrateBB::url('profile')
		);
	}

	function _png2jpg($originalFile, $outputFile) {
		$image = imagecreatefrompng($originalFile);
		imagejpeg($image, $outputFile, 100);
		imagedestroy($image);
	}

	function _webp2jpg($originalFile, $outputFile) {
		$image = imagecreatefromwebp($originalFile);
		imagejpeg($image, $outputFile, 100);
		imagedestroy($image);
	}

	function _get_field_visibility($user_id, $field) {

		$visibility_levels = get_user_meta($user_id, 'bp_xprofile_visibility_levels', true);

		// check field visibility
		$default_acc = PeepSo::ACCESS_PUBLIC;
		if (!empty($visibility_levels) && is_array($visibility_levels)) {

			foreach ($visibility_levels as $key => $value) {
				if ($key == $field) {
					switch ($value) {
						case 'public' :
							$default_acc = PeepSo::ACCESS_PUBLIC;
							break;
						case 'loggedin' :
							$default_acc = PeepSo::ACCESS_MEMBERS;
							break;
						case 'friends' :
							if (class_exists('PeepSoFriendsPlugin')) {
								$default_acc = PeepSoFriendsPlugin::ACCESS_FRIENDS;
							} else {
								$default_acc = PeepSo::ACCESS_PUBLIC;
							}
							break;
						case 'adminsonly' :
							$default_acc = PeepSo::ACCESS_PRIVATE;
							break;
					}
				}
			}
		}

		return $default_acc;
	}

	function add_memory($type, $post_id, $peepso_new_post_id) {
		global $wpdb;

		$sql = $wpdb->prepare("INSERT INTO " . $wpdb->prefix . "bp_peepso (`type`, `old_id`, `new_id`) VALUES (%s, %s, %s)", $type, $post_id, $peepso_new_post_id);
		$wpdb->query($sql);
	}

	function get_memory($type, $old_id) {
		global $wpdb;

		$sql = $wpdb->prepare("SELECT `new_id` FROM " . $wpdb->prefix . "bp_peepso WHERE `type` = %s AND `old_id` = %s", $type, $old_id);
		$row = $wpdb->get_row($sql);
		if (isset($row->new_id)) {
			return $row->new_id;
		}
	}

}

?>