<?php
global $wpdb;

$icon_error = PeepsoMigrate::get_asset('images/error.png');
$icon_tick = PeepsoMigrate::get_asset('images/tick.png');
?>

<form id="migrate-form" name="migrate_form" method="post">
	<input type="hidden" name="start_peepso_migrate" value="1" />
	<script type="text/javascript" language="javascript">
        function confirmStartMigrate() {
            document.getElementById("peepso-migrator-modal-background").style.display = "";
            document.getElementById("peepso-migrator-modal").style.display = "";
        }

        function stopMigrate() {
            document.getElementById("peepso-migrator-modal-background").style.display = "none";
            document.getElementById("peepso-migrator-modal").style.display = "none";
        }
	</script>

	<div id="peepso-migrator-modal-background" class="peepso-migrator-modal-background" style="display:none;"></div>

	<div id="peepso-migrator-modal" class="peepso-migrator-modal" style="display:none;">
		<p style="text-align:center; margin:10px 0px"><?php echo __('Please make sure gender and birthdate fields are matched as you want them to be migrated.', 'peepsomigrate'); ?>
			<br />
			<?php echo __('Also, note that any and all data that you have currently in PeepSo will be removed.', 'peepsomigrate'); ?>   
			<br />
			<?php echo __('Do you wish to proceed?', 'peepsomigrate'); ?></p>
		<div style="width:100%; text-align:center;">
			<input type="button" class="btn btn-success" value="<?php echo __('Yes', 'peepsomigrate'); ?>" onclick="document.migrate_form.submit()" />
			<input type="button" class="btn btn-info" value="<?php echo __('No', 'peepsomigrate'); ?>" onclick="javascript:stopMigrate();" />
		</div>
	</div>

	<div>
		<?php echo PeepSoTemplate::exec_template('migrate', 'header'); ?>

		<p align="justify">
			<?php echo __('This migrator has been created to enable administrators of BuddyPress-based communities to move easily to PeepSo and experience social networking for WordPress at its best. Because BuddyPress and PeepSo do not share exactly the same sets of features, some of the data on BuddyPress cannot currently be moved.', 'peepsomigrate'); ?>
		</p>

		<p align="justify">
			<?php echo __('Depending on the BuddyPress components and PeepSo plugins installed, the migrator is able to transfer the following data:', 'peepsomigrate'); ?>
		<table border="0" width="100%">
			<tr>
				<td class="plugin-check"><img src="<?php echo $icon_tick; ?>" class="image-icon"/></td>
				<td><?php echo __('User Profiles', 'peepsomigrate'); ?></td>
			</tr>
			<tr>
				<td class="plugin-check"><img src="<?php echo $icon_tick; ?>" class="image-icon"/></td>
				<td><?php echo __('User Profile Avatars and Cover images', 'peepsomigrate'); ?></td>
			</tr>
			<tr>
				<td class="plugin-check">
					<?php
					if (!class_exists('PeepSoFriendsPlugin')) {
						echo __('Requires', 'peepsomigrate') . ' <a href="https://www.peepso.com/downloads/friendso/" target="_blank">Friends Plugin</a>';
						$icon = $icon_error;
					} else {
						$icon = $icon_tick;
					}
					?>
					<img src="<?php echo $icon; ?>" class="image-icon"/>
				</td>
				<td><?php echo __('User Friends', 'peepsomigrate'); ?></td>
			</tr>
			<tr>
				<td class="plugin-check">
					<?php
					if (!class_exists('PeepSoMessagesPlugin')) {
						echo __('Requires', 'peepsomigrate') . ' <a href="https://www.peepso.com/downloads/msgso/" target="_blank">Chat Plugin</a>';
						$icon = $icon_error;
					} else {
						$icon = $icon_tick;
					}
					?>
					<img src="<?php echo $icon; ?>" class="image-icon"/>
				</td>
				<td><?php echo __('User Messages', 'peepsomigrate'); ?></td>
			</tr>
			<tr>
				<td class="plugin-check"><img src="<?php echo $icon_tick; ?>" class="image-icon"/></td>
				<td><?php echo __('Activity Stream (User status updates and comments on status updates)', 'peepsomigrate'); ?></td>
			</tr>
			<tr>
				<td class="plugin-check"><img src="<?php echo $icon_tick; ?>" class="image-icon"/></td>
				<td><?php echo __('Notifications', 'peepsomigrate'); ?></td>
			</tr>
			<tr>
				<td class="plugin-check"><img src="<?php echo $icon_tick; ?>" class="image-icon"/></td>
				<td><?php echo __('Core Profile Fields (First Name, Last Name, Gender, Birthday, About me, Website)', 'peepsomigrate'); ?>
					<br/><span class="select-field"><?php echo __('Select BuddyPress Gender Field', 'peepsomigrate'); ?></span>
					<?php
					$sql = "SELECT * FROM " . $wpdb->prefix . "bp_xprofile_fields WHERE type = 'radio' OR type = 'selectbox' ORDER BY id ASC";
					$result = $wpdb->get_results($sql);
					$option_fields = '<option value="">' . __('Select Field ...', 'peepsomigrate') . '</option>';
					$option_gender_select = array();
					$sub_select_fields = '';

					if (!empty($result)) {
						foreach ($result as $field) {
							$option_fields .= '<option value="' . $field->id . '">' . $field->name . '</option>';

							$result_gender_select = $wpdb->get_results($wpdb->prepare("SELECT * FROM " . $wpdb->prefix . "bp_xprofile_fields WHERE parent_id = %d ORDER BY id ASC", $field->id));
							$option_gender_select[$field->id] = '<option value="">' . __('Select Field ...', 'peepsomigrate') . '</option>';

							foreach ($result_gender_select as $field_gender_select) {
								$option_gender_select[$field->id] .= '<option value="' . $field_gender_select->id . '">' . $field_gender_select->name . '</option>';
							}

							ob_start();
							?>
							<div class="gender_field_detail-<?php echo $field->id; ?>" style="display:none;">
								<?php
								if (count($option_gender_select) > 0) {
									foreach ($option_gender_select as $key => $value) {
										?>
										<div class="field-gender-<?php echo $field->id; ?>" style="display:none">
											<br/><span class="select-field"><?php echo __('Select Male Field', 'peepsomigrate'); ?></span>
											<select class="select-field" name="gender_field_male_<?php echo $field->id; ?>"><?php echo $value; ?></select>
											<br/><span class="select-field"><?php echo __('Select Female Field', 'peepsomigrate'); ?></span>
											<select class="select-field" name="gender_field_female_<?php echo $field->id; ?>"><?php echo $value; ?></select>
											<?php
											for ($i = 1; $i <= (count($result_gender_select) - 2); $i++) {
												?>
												<br/><span class="select-field"><?php echo __('Select Custom Field', 'peepsomigrate'); ?> <?php echo $i + 2; ?></span>
												<select class="select-field" name="gender_field_custom<?php echo $i + 2; ?>_<?php echo $key; ?>"><?php echo $value; ?></select>
												<?php
											}
											?>
										</div>
										<?php
									}
								}
								?>
							</div>
							<?php
							$sub_select_fields = $sub_select_fields . ob_get_clean();
						}
					}
					?>
					<select class="select-field" name="gender_field">
						<?php echo $option_fields; ?>
					</select>
					<?php echo $sub_select_fields; ?>
					<script>
                        jQuery(function ($) {

                            $('[name="gender_field"]').on('change', function () {
                                $('[class*="gender_field_detail-"], [class*="field-gender-"]').hide();

                                if ($('[class*="field-gender-' + $(this).val() + '"]').length > 0) {
                                    $('.gender_field_detail-' + $(this).val() + ', [class*="field-gender-' + $(this).val() + '"]').show();
                                }
                            });

                        });
					</script>
					<br/><span class="select-field"><?php echo __('Select BuddyPress Birthdate Field', 'peepsomigrate'); ?></span>
					<select class="select-field" name="birthdate_field">
						<?php
						$sql = "SELECT * FROM " . $wpdb->prefix . "bp_xprofile_fields WHERE type = 'datebox' ORDER BY id ASC";
						$result = $wpdb->get_results($sql);
						$option_fields = '<option>' . __('Select Field ...', 'peepsomigrate') . '</option>';

						if (!empty($result)) {
							foreach ($result as $field) {
								$option_fields .= '<option value="' . $field->id . '">' . $field->name . '</option>';
							}
						}
						echo $option_fields;
						?>
					</select>
				</td>
			</tr>
			<tr>
				<td class="plugin-check">
					<img src="<?php echo $icon_tick; ?>" class="image-icon"/>
				</td>
				<td><?php echo __('Custom Profile Fields (Text, Multiple and Single Select, Date, URL... All fields will be automatically created in PeepSo and data migrated accordingly)', 'peepsomigrate'); ?></td>
			</tr>

			<tr>
				<td class="plugin-check">
					<?php
					if (!class_exists('PeepSoGroupsPlugin')) {
						echo __('Requires', 'peepsomigrate') . ' <a href="https://www.peepso.com/downloads/groupso/" target="_blank">Groups Plugin</a>';
						$icon = $icon_error;
					} else {
						$icon = $icon_tick;
					}
					?>
					<img src="<?php echo $icon; ?>" class="image-icon"/>
				</td>
				<td><?php echo __('Groups - <b>Public</b> group will be migrated as <b>Open</b> group, <b>Private</b> group will remain as <b>Private</b> group, and <b>Hidden</b> group will be migrated as <b>Secret</b> group.', 'peepsomigrate'); ?></td>
			</tr>
		</table>
		</p>

		<div style="float:left; width:90%; margin-bottom:10px; background-color:#FFFFFF; padding:5px;color:red;">
			<b style="font-size:16px;"><?php echo __('Note:', 'peepsomigrate') ?></b> <span style="font-size:14px;"><?php echo __('After running the migrator, the BuddyPress and the Migration plugins will be automatically deactivated.', 'peepsomigrate'); ?></span>
		</div>

		<div style="float:left; width:50%">
			<a href="<?php echo get_admin_url(); ?>"><?php echo __('Cancel', 'peepsomigrate'); ?></a>
		</div>

		<?php if (!defined('PEEPSO_VERSION_MISMATCH')) : ?>
		<div style="float:left; width:50%; text-align:right;">
			<input class="button-primary" type="button" onclick="javascript:confirmStartMigrate();" name="migrate" value="<?php echo __('Start Migration', 'peepsomigrate'); ?>" />
		</div>
		<?php endif; ?>

	</div>
</form>