<?php
global $wpdb;

$icon_error = PeepsoMigrateBB::get_asset('images/error.png');
$icon_tick = PeepsoMigrateBB::get_asset('images/tick.png');
?>

<form id="migrate-form" name="migrate_form" method="post">
	<input type="hidden" name="start_peepso_migrate" value="1" />
	<script type="text/javascript" language="javascript">
        function confirmStartMigrate() {
            document.getElementById("peepso-migrator-modal-background").style.display = "";
            document.getElementById("peepso-migrator-modal").style.display = "";
        }

        function stopMigrate() {
            document.getElementById("peepso-migrator-modal-background").style.display = "none";
            document.getElementById("peepso-migrator-modal").style.display = "none";
        }
	</script>

	<div id="peepso-migrator-modal-background" class="peepso-migrator-modal-background" style="display:none;"></div>

	<div id="peepso-migrator-modal" class="peepso-migrator-modal" style="display:none;">
		<p style="text-align:center; margin:10px 0px"><?php echo __('Please make sure gender and birthdate fields are matched as you want them to be migrated.', 'peepsobuddyboss'); ?>
			<br />
			<?php echo __('Also, note that any and all data that you have currently in PeepSo will be removed.', 'peepsobuddyboss'); ?>   
			<br />
			<?php echo __('Do you wish to proceed?', 'peepsobuddyboss'); ?></p>
		<div style="width:100%; text-align:center;">
			<input type="button" class="btn btn-success" value="<?php echo __('Yes', 'peepsobuddyboss'); ?>" onclick="document.migrate_form.submit()" />
			<input type="button" class="btn btn-info" value="<?php echo __('No', 'peepsobuddyboss'); ?>" onclick="javascript:stopMigrate();" />
		</div>
	</div>

	<div>
		<?php echo esc_html(PeepSoTemplate::exec_template('migrate', 'header')); ?>

		<p align="justify">
			<?php echo __('This migrator has been created to enable administrators of BuddyBoss-based communities to move easily to PeepSo and experience social networking for WordPress at its best. Because BuddyBoss and PeepSo do not share exactly the same sets of features, some of the data on BuddyBoss cannot currently be moved.', 'peepsobuddyboss'); ?>
		</p>

		<p align="justify">
			<?php echo __('Depending on the BuddyBoss components and PeepSo plugins installed, the migrator is able to transfer the following data:', 'peepsobuddyboss'); ?>
		<table border="0" width="100%">
			<tr>
				<td class="plugin-check"><img src="<?php echo esc_attr($icon_tick); ?>" class="image-icon"/></td>
				<td><?php echo __('User Profiles', 'peepsobuddyboss'); ?></td>
			</tr>
			<tr>
				<td class="plugin-check"><img src="<?php echo esc_attr($icon_tick); ?>" class="image-icon"/></td>
				<td><?php echo __('User Profile Avatars and Cover images', 'peepsobuddyboss'); ?></td>
			</tr>
			<tr>
				<td class="plugin-check">
					<?php
					if (!class_exists('PeepSoFriendsPlugin')) {
						echo __('Requires', 'peepsobuddyboss') . ' <a href="https://www.peepso.com/downloads/friendso/" target="_blank">Friends Plugin</a>';
						$icon = $icon_error;
					} else {
						$icon = $icon_tick;
					}
					?>
					<img src="<?php echo esc_attr($icon); ?>" class="image-icon"/>
				</td>
				<td><?php echo __('User Friends', 'peepsobuddyboss'); ?></td>
			</tr>
			<tr>
				<td class="plugin-check">
					<?php
					if (!class_exists('PeepSoMessagesPlugin')) {
						echo __('Requires', 'peepsobuddyboss') . ' <a href="https://www.peepso.com/downloads/msgso/" target="_blank">Chat Plugin</a>';
						$icon = $icon_error;
					} else {
						$icon = $icon_tick;
					}
					?>
					<img src="<?php echo esc_attr($icon); ?>" class="image-icon"/>
				</td>
				<td><?php echo __('User Messages', 'peepsobuddyboss'); ?></td>
			</tr>
			<tr>
				<td class="plugin-check"><img src="<?php echo esc_attr($icon_tick); ?>" class="image-icon"/></td>
				<td><?php echo __('Activity Stream (User status updates and comments on status updates)', 'peepsobuddyboss'); ?></td>
			</tr>
			<tr>
				<td class="plugin-check"><img src="<?php echo esc_attr($icon_tick); ?>" class="image-icon"/></td>
				<td><?php echo __('Notifications', 'peepsobuddyboss'); ?></td>
			</tr>
			<tr>
				<td class="plugin-check"><img src="<?php echo esc_attr($icon_tick); ?>" class="image-icon"/></td>
				<td><?php echo __('Core Profile Fields (First Name, Last Name, Gender, Birthday, About me, Website)', 'peepsobuddyboss'); ?>
					<br/><span class="select-field"><?php echo __('Select BuddyBoss Gender Field', 'peepsobuddyboss'); ?></span>
					<?php
					$sql = "SELECT * FROM " . $wpdb->prefix . "bp_xprofile_fields WHERE type = 'gender' ORDER BY id ASC";
					$result = $wpdb->get_results($sql);
					$option_gender_select = array();
					?>
					<select class="select-field" name="gender_field">
						<option value=""><?php echo __('Select Field ...', 'peepsobuddyboss'); ?></option>
						<?php
						if (!empty($result)) {
							foreach ($result as $field) {
								?>
								<option value="<?php echo esc_attr($field->id); ?>"><?php echo esc_attr($field->name); ?></option>
								<?php
							}
						}
						?>
					</select>
					<?php
					if (!empty($result)) {
						foreach ($result as $field) {
							$result_gender_select = $wpdb->get_results($wpdb->prepare("SELECT * FROM " . $wpdb->prefix . "bp_xprofile_fields WHERE parent_id = %d ORDER BY id ASC", $field->id));
							$option_gender_select[$field->id] = '<option value="">' . __('Select Field ...', 'peepsobuddyboss') . '</option>';
							?>
							<div class="gender_field_detail-<?php echo esc_attr($field->id); ?>" style="display:none;">
								<div class="field-gender-<?php echo esc_attr($field->id); ?>" style="display:none">
									<br/>
									<span class="select-field"><?php echo __('Select Male Field', 'peepsobuddyboss'); ?></span>
									<select class="select-field" name="gender_field_male_<?php echo esc_attr($field->id); ?>">
										<option value=""><?php echo __('Select Field ...', 'peepsobuddyboss'); ?></option>
										<?php
										foreach ($result_gender_select as $field_gender_select) {
											?>
											<option value="<?php echo esc_attr($field_gender_select->id); ?>"><?php echo esc_attr($field_gender_select->name); ?></option>
											<?php
										}
										?>
									</select>
									<br/>
									<span class="select-field"><?php echo __('Select Female Field', 'peepsobuddyboss'); ?></span>
									<select class="select-field" name="gender_field_female_<?php echo esc_attr($field->id); ?>">
										<option value=""><?php echo __('Select Field ...', 'peepsobuddyboss'); ?></option>
										<?php
										foreach ($result_gender_select as $field_gender_select) {
											?>
											<option value="<?php echo esc_attr($field_gender_select->id); ?>"><?php echo esc_attr($field_gender_select->name); ?></option>
											<?php
										}
										?>
									</select>
									<?php
									for ($i = 1; $i <= (count($result_gender_select) - 2); $i++) {
										?>
										<br/>
										<span class="select-field"><?php echo __('Select Custom Field', 'peepsobuddyboss'); ?> <?php echo $i + 2; ?></span>
										<select class="select-field" name="gender_field_custom<?php echo $i + 2; ?>_<?php echo $field->id; ?>">
											<option value=""><?php echo __('Select Field ...', 'peepsobuddyboss'); ?></option>
											<?php
											foreach ($result_gender_select as $field_gender_select) {
												?>
												<option value="<?php echo esc_attr($field_gender_select->id); ?>"><?php echo esc_attr($field_gender_select->name); ?></option>
												<?php
											}
											?>
										</select>
										<?php
									}
									?>
								</div>
							</div>
							<?php
						}
					}
					?>
					<script>
                        jQuery(function ($) {

                            $('[name="gender_field"]').on('change', function () {
                                $('[class*="gender_field_detail-"], [class*="field-gender-"]').hide();

                                if ($('[class*="field-gender-' + $(this).val() + '"]').length > 0) {
                                    $('.gender_field_detail-' + $(this).val() + ', [class*="field-gender-' + $(this).val() + '"]').show();
                                }
                            });

                        });
					</script>
					<br/><span class="select-field"><?php echo __('Select BuddyBoss Birthdate Field', 'peepsobuddyboss'); ?></span>
					<select class="select-field" name="birthdate_field">
						<option><?php echo __('Select Field ...', 'peepsobuddyboss'); ?></option>
						<?php
						$sql = "SELECT * FROM " . $wpdb->prefix . "bp_xprofile_fields WHERE type = 'datebox' ORDER BY id ASC";
						$result = $wpdb->get_results($sql);

						if (!empty($result)) {
							foreach ($result as $field) {
								?>
								<option value="<?php echo esc_attr($field->id); ?>"><?php echo esc_attr($field->name); ?></option>
								<?php
							}
						}
						?>
					</select>
				</td>
			</tr>
			<tr>
				<td class="plugin-check">
					<img src="<?php echo esc_attr($icon_tick); ?>" class="image-icon"/>
				</td>
				<td><?php echo __('Custom Profile Fields (Text, Multiple and Single Select, Date, URL... All fields will be automatically created in PeepSo and data migrated accordingly)', 'peepsobuddyboss'); ?></td>
			</tr>

			<tr>
				<td class="plugin-check">
					<?php
					if (!class_exists('PeepSoGroupsPlugin')) {
						echo __('Requires', 'peepsobuddyboss') . ' <a href="https://www.peepso.com/downloads/groupso/" target="_blank">Groups Plugin</a>';
						$icon = $icon_error;
					} else {
						$icon = $icon_tick;
					}
					?>
					<img src="<?php echo esc_attr($icon); ?>" class="image-icon"/>
				</td>
				<td><?php echo __('Groups - <b>Public</b> group will be migrated as <b>Open</b> group, <b>Private</b> group will remain as <b>Private</b> group, and <b>Hidden</b> group will be migrated as <b>Secret</b> group.', 'peepsobuddyboss'); ?></td>
			</tr>
		</table>
		</p>

		<div style="float:left; width:90%; margin-bottom:10px; background-color:#FFFFFF; padding:5px;color:red;">
			<b style="font-size:16px;"><?php echo __('Note:', 'peepsobuddyboss') ?></b> <span style="font-size:14px;"><?php echo __('After running the migrator, the BuddyBoss and the Migration plugins will be automatically deactivated.', 'peepsobuddyboss'); ?></span>
		</div>

		<div style="float:left; width:50%">
			<a href="<?php echo get_admin_url(); ?>"><?php echo __('Cancel', 'peepsobuddyboss'); ?></a>
		</div>

		<?php if (!defined('PEEPSO_VERSION_MISMATCH')) : ?>
		<div style="float:left; width:50%; text-align:right;">
			<input class="button-primary" type="button" onclick="javascript:confirmStartMigrate();" name="migrate" value="<?php echo __('Start Migration', 'peepsobuddyboss'); ?>" />
		</div>
		<?php endif; ?>

	</div>
</form>